/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class JdbcTypeConverter {
    private JdbcTypeConverter() {
    }

    public static int toJdbcType(FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.isDbKey()) {
            return -8;
        }
        return JdbcTypeConverter.fromFirebirdToJdbcType(fieldDescriptor.getType(), fieldDescriptor.getSubType(), fieldDescriptor.getScale());
    }

    public static boolean isJdbcType(FieldDescriptor fieldDescriptor, int jdbcType) {
        return JdbcTypeConverter.toJdbcType(fieldDescriptor) == jdbcType;
    }

    public static int fromFirebirdToJdbcType(int firebirdType, int subtype, int scale) {
        return switch (firebirdType &= 0xFFFFFFFE) {
            case 480, 496, 500, 530, 580, 32752 -> {
                if (subtype == 2) {
                    yield 3;
                }
                if (subtype == 1 || scale < 0) {
                    yield 2;
                }
                switch (firebirdType) {
                    case 500: {
                        yield 5;
                    }
                    case 496: {
                        yield 4;
                    }
                    case 580: {
                        yield -5;
                    }
                    case 480: 
                    case 530: {
                        yield 8;
                    }
                    case 32752: {
                        yield 2;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + firebirdType);
            }
            case 482 -> 6;
            case 32760, 32762 -> -6001;
            case 452 -> {
                if (subtype == 1) {
                    yield -2;
                }
                yield 1;
            }
            case 448 -> {
                if (subtype == 1) {
                    yield -3;
                }
                yield 12;
            }
            case 510 -> 93;
            case 560 -> 92;
            case 570 -> 91;
            case 32748, 32754 -> 2014;
            case 32750, 32756 -> 2013;
            case 520 -> {
                if (subtype < 0) {
                    yield 2004;
                }
                if (subtype == 1) {
                    yield -1;
                }
                yield -4;
            }
            case 32764 -> 16;
            case 32766 -> 0;
            case 540 -> 2003;
            default -> 1111;
        };
    }

    public static int fromMetaDataToJdbcType(int metaDataType, int subtype, int scale) {
        return JdbcTypeConverter.fromFirebirdToJdbcType(JdbcTypeConverter.fromMetaDataToFirebirdType(metaDataType), subtype, scale);
    }

    public static int fromMetaDataToFirebirdType(int metaDataType) {
        return switch (metaDataType) {
            case 7 -> 500;
            case 8 -> 496;
            case 16 -> 580;
            case 24 -> 32760;
            case 25 -> 32762;
            case 26 -> 32752;
            case 9 -> 550;
            case 10 -> 482;
            case 27 -> 480;
            case 11 -> 530;
            case 12 -> 570;
            case 13 -> 560;
            case 35 -> 510;
            case 28 -> 32756;
            case 29 -> 32754;
            case 30 -> 32750;
            case 31 -> 32748;
            case 14 -> 452;
            case 37, 40 -> 448;
            case 261 -> 520;
            case 23 -> 32764;
            default -> 32766;
        };
    }

    public static String getTypeName(int jdbcType, int firebirdType, int subtype, int scale) {
        return switch (jdbcType) {
            case 5 -> "SMALLINT";
            case 4 -> "INTEGER";
            case -5 -> "BIGINT";
            case 8 -> "DOUBLE PRECISION";
            case -6001 -> "DECFLOAT";
            case 6 -> "FLOAT";
            case 3 -> "DECIMAL";
            case 2 -> {
                if (firebirdType == 32752 && subtype == 0 && scale == 0) {
                    yield "INT128";
                }
                yield "NUMERIC";
            }
            case -2, 1 -> "CHAR";
            case -3, 12 -> "VARCHAR";
            case -1, 2005, 2011 -> "BLOB SUB_TYPE TEXT";
            case -4 -> {
                if (subtype == 0) {
                    yield "BLOB SUB_TYPE BINARY";
                }
                yield "BLOB SUB_TYPE " + subtype;
            }
            case 2004 -> "BLOB SUB_TYPE " + subtype;
            case 93 -> "TIMESTAMP";
            case 92 -> "TIME";
            case 91 -> "DATE";
            case 2014 -> "TIMESTAMP WITH TIME ZONE";
            case 2013 -> "TIME WITH TIME ZONE";
            case 16 -> "BOOLEAN";
            case 0 -> "NULL";
            case 2003 -> "ARRAY";
            default -> "OTHER";
        };
    }
}

