/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.wire.AbstractFbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireAsynchronousChannel;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireStatement;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;

public class V10Database
extends AbstractFbWireDatabase
implements FbWireDatabase {
    private BlrCalculator blrCalculator;

    protected V10Database(WireDatabaseConnection connection, ProtocolDescriptor descriptor) {
        super(connection, descriptor);
    }

    @Override
    public final void attach() throws SQLException {
        try {
            DatabaseParameterBuffer dpb = this.protocolDescriptor.createDatabaseParameterBuffer((WireDatabaseConnection)this.connection);
            this.attachOrCreate(dpb, false);
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    protected final void attachOrCreate(DatabaseParameterBuffer dpb, boolean create) throws SQLException {
        this.checkConnected();
        this.requireNotAttached();
        try (LockCloseable ignored = this.withLock();){
            try {
                this.sendAttachOrCreate(dpb, create);
                this.receiveAttachOrCreateResponse();
            }
            catch (SQLException e) {
                this.safelyDetach();
                throw e;
            }
            this.setAttached();
            this.afterAttachActions();
        }
    }

    private void sendAttachOrCreate(DatabaseParameterBuffer dpb, boolean create) throws SQLException {
        try {
            this.sendAttachOrCreateToBuffer(dpb, create);
            this.getXdrOut().flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receiveAttachOrCreateResponse() throws SQLException {
        try {
            this.authReceiveResponse(null);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    protected final void sendAttachOrCreateToBuffer(DatabaseParameterBuffer dpb, boolean create) throws SQLException, IOException {
        int operation = create ? 20 : 19;
        XdrOutputStream xdrOut = this.getXdrOut();
        Encoding filenameEncoding = this.getFilenameEncoding(dpb);
        xdrOut.writeInt(operation);
        xdrOut.writeInt(0);
        xdrOut.writeString(((WireDatabaseConnection)this.connection).getAttachObjectName(), filenameEncoding);
        xdrOut.writeTyped(dpb);
    }

    protected Encoding getFilenameEncoding(DatabaseParameterBuffer dpb) {
        String filenameCharset = this.getConnectionProperties().getProperty("filename_charset");
        if (filenameCharset != null) {
            return this.getEncodingFactory().getOrCreateEncodingForCharset(Charset.forName(filenameCharset));
        }
        return this.getEncoding();
    }

    protected final void processAttachOrCreateResponse(GenericResponse genericResponse) {
    }

    protected final void afterAttachActions() throws SQLException {
        ((WireDatabaseConnection)this.connection).clearAuthData();
        this.getDatabaseInfo(this.getDescribeDatabaseInfoBlock(), 1024, this.getDatabaseInformationProcessor());
        ((WireDatabaseConnection)this.connection).resetSocketTimeout();
    }

    @Override
    protected final void internalDetach() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                this.sendDetachDisconnect();
                if (this.isAttached()) {
                    this.receiveDetachResponse();
                }
                try {
                    this.closeConnection();
                }
                catch (IOException e) {
                    throw FbExceptionBuilder.ioWriteError(e);
                }
            }
            catch (SQLException ex) {
                try {
                    this.closeConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
            finally {
                this.setDetached();
            }
        }
    }

    private void sendDetachDisconnect() throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            if (this.isAttached()) {
                xdrOut.writeInt(21);
                xdrOut.writeInt(0);
            }
            xdrOut.writeInt(6);
            xdrOut.flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receiveDetachResponse() throws SQLException {
        try {
            this.wireOperations.readResponse(null);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public final void createDatabase() throws SQLException {
        try {
            DatabaseParameterBuffer dpb = this.protocolDescriptor.createDatabaseParameterBuffer((WireDatabaseConnection)this.connection);
            this.attachOrCreate(dpb, true);
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    @Override
    public final void dropDatabase() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkAttached();
            try {
                this.sendDropDatabase();
                this.receiveDropDatabaseResponse();
            }
            finally {
                try {
                    this.closeConnection();
                }
                catch (IOException e) {
                    System.getLogger(this.getClass().getName()).log(System.Logger.Level.DEBUG, "Ignored exception on connection close in dropDatabase()", (Throwable)e);
                }
            }
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    private void sendDropDatabase() throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            xdrOut.writeInt(81);
            xdrOut.writeInt(0);
            xdrOut.flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receiveDropDatabaseResponse() throws SQLException {
        try {
            this.readResponse(null);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public final FbWireTransaction startTransaction(TransactionParameterBuffer tpb) throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            this.checkAttached();
            this.sendStartTransaction(tpb);
            FbWireTransaction fbWireTransaction = this.receiveTransactionResponse(TransactionState.ACTIVE);
            if (ignored != null) {
                ignored.close();
            }
            return fbWireTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException ex) {
                this.exceptionListenerDispatcher.errorOccurred(ex);
                throw ex;
            }
        }
    }

    @Override
    public FbTransaction startTransaction(String statementText) throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            this.checkAttached();
            this.sendExecuteImmediate(statementText, null);
            FbWireTransaction fbWireTransaction = this.receiveTransactionResponse(TransactionState.ACTIVE);
            if (ignored != null) {
                ignored.close();
            }
            return fbWireTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException ex) {
                this.exceptionListenerDispatcher.errorOccurred(ex);
                throw ex;
            }
        }
    }

    private void sendStartTransaction(TransactionParameterBuffer tpb) throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            xdrOut.writeInt(29);
            xdrOut.writeInt(0);
            xdrOut.writeTyped(tpb);
            xdrOut.flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private FbWireTransaction receiveTransactionResponse(TransactionState initialState) throws SQLException {
        try {
            FbWireTransaction transaction = this.protocolDescriptor.createTransaction(this, this.readGenericResponse(null).objectHandle(), initialState);
            this.transactionAdded(transaction);
            return transaction;
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public final FbTransaction reconnectTransaction(long transactionId) throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            this.checkAttached();
            this.sendReconnect(transactionId);
            FbWireTransaction fbWireTransaction = this.receiveTransactionResponse(TransactionState.PREPARED);
            if (ignored != null) {
                ignored.close();
            }
            return fbWireTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException ex) {
                this.exceptionListenerDispatcher.errorOccurred(ex);
                throw ex;
            }
        }
    }

    private void sendReconnect(long transactionId) throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            xdrOut.writeInt(33);
            xdrOut.writeInt(0);
            byte[] transactionIdBuffer = this.getTransactionIdBuffer(transactionId);
            xdrOut.writeBuffer(transactionIdBuffer);
            xdrOut.flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    @Override
    public final FbStatement createStatement(FbTransaction transaction) throws SQLException {
        try {
            this.checkAttached();
            FbWireStatement stmt = this.protocolDescriptor.createStatement(this);
            stmt.addExceptionListener(this.exceptionListenerDispatcher);
            stmt.setTransaction(transaction);
            return stmt;
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void cancelOperation(int kind) throws SQLException {
        try {
            if (kind != 4) {
                throw new SQLFeatureNotSupportedException(String.format("Cancel Operation isn't supported in this version of the wire protocol (%d).", this.protocolDescriptor.getVersion()), "0A000");
            }
            this.forceClose();
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    @Override
    public final void executeImmediate(String statementText, FbTransaction transaction) throws SQLException {
        try {
            if (this.isAttached()) {
                if (transaction == null) {
                    throw FbExceptionBuilder.toException(337248270);
                }
                TransactionHelper.checkTransactionActive(transaction);
            } else if (transaction != null) {
                throw FbExceptionBuilder.toException(337248271);
            }
            try (LockCloseable ignored = this.withLock();){
                this.sendExecuteImmediate(statementText, transaction);
                this.receiveExecuteImmediateResponse();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void sendExecuteImmediate(String statementText, FbTransaction transaction) throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            xdrOut.writeInt(64);
            xdrOut.writeInt(transaction != null ? transaction.getHandle() : 0);
            xdrOut.writeInt(0);
            xdrOut.writeInt(this.getConnectionDialect());
            xdrOut.writeString(statementText, this.getEncoding());
            xdrOut.writeBuffer(null);
            xdrOut.writeInt(0);
            this.getXdrOut().flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receiveExecuteImmediateResponse() throws SQLException {
        try {
            if (!this.isAttached()) {
                this.processAttachOrCreateResponse(this.readGenericResponse(null));
            }
            this.readGenericResponse(null);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public void releaseObject(int operation, int objectId) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkAttached();
            try {
                this.doReleaseObjectPacket(operation, objectId);
                this.getXdrOut().flush();
            }
            catch (IOException e) {
                throw FbExceptionBuilder.ioWriteError(e);
            }
            try {
                this.processReleaseObjectResponse(this.readResponse(null));
            }
            catch (IOException e) {
                throw FbExceptionBuilder.ioReadError(e);
            }
        }
    }

    @Override
    public final FbWireAsynchronousChannel initAsynchronousChannel() throws SQLException {
        int port;
        int auxHandle;
        this.checkAttached();
        try (LockCloseable ignored = this.withLock();){
            try {
                XdrOutputStream xdrOut = this.getXdrOut();
                xdrOut.writeInt(53);
                xdrOut.writeInt(1);
                xdrOut.writeInt(0);
                xdrOut.writeInt(0);
                xdrOut.flush();
            }
            catch (IOException e) {
                throw FbExceptionBuilder.ioWriteError(e);
            }
            try {
                GenericResponse response = this.readGenericResponse(null);
                auxHandle = response.objectHandle();
                byte[] data = response.data();
                port = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
            }
            catch (IOException e) {
                throw FbExceptionBuilder.ioReadError(e);
            }
        }
        FbWireAsynchronousChannel channel = this.protocolDescriptor.createAsynchronousChannel(this);
        channel.connect(((WireDatabaseConnection)this.connection).getServerName(), port, auxHandle);
        return channel;
    }

    protected final void doReleaseObjectPacket(int operation, int objectId) throws IOException, SQLException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(operation);
        xdrOut.writeInt(objectId);
    }

    protected final void processReleaseObjectResponse(Response response) {
    }

    @Override
    public final BlrCalculator getBlrCalculator() {
        if (this.blrCalculator == null) {
            this.blrCalculator = this.protocolDescriptor.createBlrCalculator(this);
        }
        return this.blrCalculator;
    }

    @Override
    public final void authReceiveResponse(FbWireAttachment.AcceptPacket acceptPacket) throws IOException, SQLException {
        DbCryptCallback dbCryptCallback = ((WireDatabaseConnection)this.connection).createDbCryptCallback();
        this.wireOperations.authReceiveResponse(acceptPacket, dbCryptCallback, this::processAttachOrCreateResponse);
    }
}

