/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt;

import java.util.Arrays;
import java.util.Objects;
import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfig;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;

record CryptSessionConfigImpl(EncryptionIdentifier encryptionIdentifier, byte[] encryptKey, byte[] decryptKey, byte[] specificData) implements CryptSessionConfig
{
    CryptSessionConfigImpl {
        Objects.requireNonNull(encryptionIdentifier, "encryptionIdentifier");
        encryptKey = (byte[])Objects.requireNonNull(encryptKey, "encryptKey").clone();
        decryptKey = (byte[])Objects.requireNonNull(decryptKey, "decryptKey").clone();
        specificData = specificData != null ? (byte[])specificData.clone() : null;
    }

    @Override
    public void close() {
        Arrays.fill(this.encryptKey, (byte)0);
        Arrays.fill(this.decryptKey, (byte)0);
        if (this.specificData != null) {
            Arrays.fill(this.specificData, (byte)0);
        }
    }
}

