/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLPermission;
import java.util.concurrent.atomic.AtomicReference;
import org.firebirdsql.gds.ng.monitor.Operation;
import org.firebirdsql.gds.ng.monitor.OperationAware;

public final class OperationMonitor {
    private static final SQLPermission PERMISSION_INIT_OPERATION_AWARE = new SQLPermission("org.firebirdsql.jaybird.initOperationAware");
    private static final AtomicReference<OperationAware> instance = new AtomicReference<NoOpOperationAware>(NoOpOperationAware.INSTANCE);

    private OperationMonitor() {
    }

    static void startOperation(Operation operation) {
        OperationAware operationAware = instance.get();
        operationAware.startOperation(operation);
    }

    static void endOperation(Operation operation) {
        OperationAware operationAware = instance.get();
        operationAware.endOperation(operation);
    }

    public static void initOperationAware(OperationAware operationAware) {
        PERMISSION_INIT_OPERATION_AWARE.checkGuard(OperationMonitor.class);
        instance.set(operationAware != null ? operationAware : NoOpOperationAware.INSTANCE);
    }

    private static final class NoOpOperationAware
    implements OperationAware {
        private static final NoOpOperationAware INSTANCE = new NoOpOperationAware();

        private NoOpOperationAware() {
        }

        @Override
        public void startOperation(Operation operation) {
        }

        @Override
        public void endOperation(Operation operation) {
        }
    }
}

