/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.firebirdsql.encodings.ConnectionEncodingFactory;
import org.firebirdsql.encodings.DefaultEncodingDefinition;
import org.firebirdsql.encodings.DefaultEncodingSet;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.EncodingGeneric;
import org.firebirdsql.encodings.EncodingSet;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.jaybird.util.PluginLoader;

public final class EncodingFactory
implements IEncodingFactory {
    private static final System.Logger log = System.getLogger(EncodingFactory.class.getName());
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final int MAX_NORMAL_CHARSET_ID = 255;
    public static final String ENCODING_NAME_NONE = "NONE";
    public static final String ENCODING_NAME_OCTETS = "OCTETS";
    private final Map<String, EncodingDefinition> firebirdEncodingToDefinition = new LinkedHashMap<String, EncodingDefinition>(128);
    private final EncodingDefinition[] firebirdCharacterSetIdToDefinition = new EncodingDefinition[256];
    private final Map<Charset, EncodingDefinition> javaCharsetToDefinition = new ConcurrentHashMap<Charset, EncodingDefinition>();
    private final Map<String, EncodingDefinition> javaAliasesToDefinition = new ConcurrentHashMap<String, EncodingDefinition>();
    private final Encoding defaultEncoding;
    private final EncodingDefinition defaultEncodingDefinition;
    private final ConcurrentMap<Class<? extends DatatypeCoder>, DatatypeCoder> datatypeCoderCache = new ConcurrentHashMap<Class<? extends DatatypeCoder>, DatatypeCoder>(3);
    private final Map<EncodingDefinition, ConnectionEncodingFactory> connectionEncodingFactoryCache = new ConcurrentHashMap<EncodingDefinition, ConnectionEncodingFactory>();

    private EncodingFactory(Iterator<EncodingSet> encodingSets) {
        while (encodingSets.hasNext()) {
            this.processEncodingSet(encodingSets.next());
        }
        this.firebirdCharacterSetIdToDefinition[127] = null;
        EncodingDefinition candidateDefinition = this.getEncodingDefinitionByCharset(DEFAULT_CHARSET);
        if (candidateDefinition != null && !candidateDefinition.isInformationOnly()) {
            this.defaultEncoding = candidateDefinition.getEncoding();
            this.defaultEncodingDefinition = candidateDefinition;
        } else {
            this.defaultEncoding = new EncodingGeneric(DEFAULT_CHARSET);
            this.defaultEncodingDefinition = new DefaultEncodingDefinition(ENCODING_NAME_NONE, DEFAULT_CHARSET, 1, 0, false);
        }
    }

    @Override
    public Encoding getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public static Encoding getPlatformEncoding() {
        return EncodingFactory.getRootEncodingFactory().getDefaultEncoding();
    }

    @Override
    public EncodingDefinition getDefaultEncodingDefinition() {
        return this.defaultEncodingDefinition;
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByFirebirdName(String firebirdEncodingName) {
        return firebirdEncodingName != null ? this.firebirdEncodingToDefinition.get(firebirdEncodingName.toLowerCase(Locale.ROOT)) : null;
    }

    public Encoding getEncodingForFirebirdName(String firebirdEncodingName, Encoding fallbackEncoding) {
        return this.returnEncodingOrFallback(this.getEncodingDefinitionByFirebirdName(firebirdEncodingName), fallbackEncoding);
    }

    @Override
    public Encoding getEncodingForFirebirdName(String firebirdEncodingName) {
        return this.getEncodingForFirebirdName(firebirdEncodingName, null);
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByCharacterSetId(int firebirdCharacterSetId) {
        return this.firebirdCharacterSetIdToDefinition[firebirdCharacterSetId & 0xFF];
    }

    public Encoding getEncodingForCharacterSetId(int firebirdCharacterSetId, Encoding fallbackEncoding) {
        return this.returnEncodingOrFallback(this.getEncodingDefinitionByCharacterSetId(firebirdCharacterSetId), fallbackEncoding);
    }

    @Override
    public Encoding getEncodingForCharacterSetId(int firebirdCharacterSetId) {
        return this.getEncodingForCharacterSetId(firebirdCharacterSetId, null);
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByCharset(Charset charset) {
        EncodingDefinition encodingDefinition = this.javaCharsetToDefinition.get(charset);
        if (encodingDefinition != null) {
            return encodingDefinition;
        }
        return this.findAndMapEncodingDefinition(charset);
    }

    private EncodingDefinition findAndMapEncodingDefinition(Charset charset) {
        Set<String> potentialNames = EncodingFactory.toLowerCaseAliasSet(charset);
        for (EncodingDefinition encodingDefinition : this.firebirdEncodingToDefinition.values()) {
            String javaEncodingName = encodingDefinition.getJavaEncodingName();
            if (javaEncodingName == null || encodingDefinition.isFirebirdOnly() || !potentialNames.contains(javaEncodingName.toLowerCase(Locale.ROOT))) continue;
            this.registerJavaMappingForEncodingDefinition(encodingDefinition);
            return encodingDefinition;
        }
        return null;
    }

    @Override
    public Encoding getEncodingForCharset(Charset charset, Encoding fallbackEncoding) {
        return this.returnEncodingOrFallback(this.getEncodingDefinitionByCharset(charset), fallbackEncoding);
    }

    @Override
    public Encoding getEncodingForCharset(Charset charset) {
        return this.getEncodingForCharset(charset, null);
    }

    @Override
    public Encoding getOrCreateEncodingForCharset(Charset charset) {
        return this.getEncodingForCharset(charset, new EncodingGeneric(charset));
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByCharsetAlias(String charsetAlias) {
        if (charsetAlias == null) {
            return null;
        }
        EncodingDefinition encodingDefinition = this.javaAliasesToDefinition.get(charsetAlias.toLowerCase(Locale.ROOT));
        if (encodingDefinition != null) {
            return encodingDefinition;
        }
        return this.resolveEncodingDefinitionByCharset(charsetAlias);
    }

    public Encoding getEncodingForCharsetAlias(String charsetAlias, Encoding fallbackEncoding) {
        return this.returnEncodingOrFallback(this.getEncodingDefinitionByCharsetAlias(charsetAlias), fallbackEncoding);
    }

    @Override
    public Encoding getEncodingForCharsetAlias(String charsetAlias) {
        return this.getEncodingForCharsetAlias(charsetAlias, null);
    }

    @Override
    public EncodingDefinition getEncodingDefinition(String firebirdEncodingName, String javaCharsetAlias) {
        try {
            EncodingDefinition encodingDefinition = null;
            Charset charset = null;
            if (firebirdEncodingName != null) {
                encodingDefinition = this.getEncodingDefinitionByFirebirdName(firebirdEncodingName);
                if (javaCharsetAlias != null) {
                    charset = Charset.forName(javaCharsetAlias);
                } else if (encodingDefinition != null) {
                    charset = encodingDefinition.getJavaCharset();
                }
            } else if (javaCharsetAlias != null && (encodingDefinition = this.getEncodingDefinitionByCharsetAlias(javaCharsetAlias)) != null) {
                charset = encodingDefinition.getJavaCharset();
            }
            if (encodingDefinition == null) {
                return null;
            }
            if (!encodingDefinition.isInformationOnly() && (charset == null || encodingDefinition.getJavaCharset().equals(charset))) {
                return encodingDefinition;
            }
            if (charset != null) {
                return new DefaultEncodingDefinition(encodingDefinition.getFirebirdEncodingName(), charset, encodingDefinition.getMaxBytesPerChar(), encodingDefinition.getFirebirdCharacterSetId(), false);
            }
            if (ENCODING_NAME_NONE.equalsIgnoreCase(firebirdEncodingName)) {
                encodingDefinition = this.getDefaultEncodingDefinition();
                return new DefaultEncodingDefinition(ENCODING_NAME_NONE, encodingDefinition.getJavaCharset(), 1, 0, false);
            }
            return null;
        }
        catch (Exception e) {
            log.log(System.Logger.Level.DEBUG, () -> "Exception looking up encoding definition for firebirdEncodingName %s, javaCharsetAlias %s".formatted(firebirdEncodingName, javaCharsetAlias), (Throwable)e);
            return null;
        }
    }

    @Override
    public IEncodingFactory withDefaultEncodingDefinition(EncodingDefinition encodingDefinition) {
        EncodingDefinition resolvedEncodingDefinition = encodingDefinition != null && !encodingDefinition.isInformationOnly() ? encodingDefinition : this.getDefaultEncodingDefinition();
        return this.connectionEncodingFactoryCache.computeIfAbsent(resolvedEncodingDefinition, def -> new ConnectionEncodingFactory(this, (EncodingDefinition)def));
    }

    @Override
    public IEncodingFactory withDefaultEncodingDefinition(Charset charset) {
        return this.withDefaultEncodingDefinition(this.getEncodingDefinitionByCharset(charset));
    }

    @Override
    public <T extends DatatypeCoder> T getOrCreateDatatypeCoder(Class<T> datatypeCoderClass, Function<IEncodingFactory, T> datatypeCoderFactory) {
        return (T)((DatatypeCoder)datatypeCoderClass.cast(this.datatypeCoderCache.computeIfAbsent(datatypeCoderClass, clazz -> (DatatypeCoder)datatypeCoderFactory.apply(this))));
    }

    public IEncodingFactory withDefaultEncodingDefinition() {
        return this.withDefaultEncodingDefinition(this.getDefaultEncodingDefinition());
    }

    private static NavigableSet<EncodingSet> loadEncodingSets() {
        TreeSet<EncodingSet> encodingSets = new TreeSet<EncodingSet>(EncodingFactory.encodingSetComparator());
        encodingSets.addAll(PluginLoader.findPlugins(EncodingSet.class, List.of(), PluginLoader.ClassSource.PLUGIN_CLASS_LOADER));
        return encodingSets;
    }

    private void processEncodingSet(EncodingSet encodingSet) {
        log.log(System.Logger.Level.DEBUG, "Processing EncodingSet {0} with preference weight {1}", encodingSet.getClass().getName(), encodingSet.getPreferenceWeight());
        for (EncodingDefinition encodingDefinition : encodingSet.getEncodings()) {
            this.processEncodingDefinition(encodingDefinition);
        }
    }

    private void processEncodingDefinition(EncodingDefinition encodingDefinition) {
        String firebirdEncodingName = encodingDefinition.getFirebirdEncodingName();
        int firebirdCharacterSetId = encodingDefinition.getFirebirdCharacterSetId();
        if (this.firebirdEncodingToDefinition.containsKey(firebirdEncodingName.toLowerCase(Locale.ROOT))) {
            log.log(System.Logger.Level.DEBUG, "Skipped loading encoding definition for Firebird encoding {0}, already loaded a definition for that name", firebirdEncodingName);
            return;
        }
        if (firebirdCharacterSetId == 127) {
            log.log(System.Logger.Level.DEBUG, "Skipped loading encoding definition for Firebird encoding {0}, as it declared itself as the connection character set (FirebirdCharacterSetId 127 or CS_dynamic)", firebirdEncodingName);
            return;
        }
        if (firebirdCharacterSetId < 0 || firebirdCharacterSetId > 255) {
            log.log(System.Logger.Level.WARNING, "Skipped loading encoding definition for Firebird encoding {0}, as it declared itself as FirebirdCharacterSetId {1}, which is outside the range [0, 255]", firebirdEncodingName, firebirdCharacterSetId);
            return;
        }
        this.firebirdEncodingToDefinition.put(firebirdEncodingName.toLowerCase(Locale.ROOT), encodingDefinition);
        this.firebirdCharacterSetIdToDefinition[firebirdCharacterSetId] = encodingDefinition;
    }

    private void registerJavaMappingForEncodingDefinition(EncodingDefinition encodingDefinition) {
        Charset charset = encodingDefinition.getJavaCharset();
        if (encodingDefinition.isInformationOnly() || encodingDefinition.isFirebirdOnly() || charset == null) {
            return;
        }
        EncodingDefinition currentEncodingDefinition = this.javaCharsetToDefinition.get(charset);
        if (currentEncodingDefinition == null) {
            this.javaCharsetToDefinition.put(charset, encodingDefinition);
            this.javaAliasesToDefinition.put(charset.name().toLowerCase(Locale.ROOT), encodingDefinition);
            for (String charsetAlias : charset.aliases()) {
                this.javaAliasesToDefinition.put(charsetAlias.toLowerCase(Locale.ROOT), encodingDefinition);
            }
        } else {
            log.log(System.Logger.Level.DEBUG, "Not mapping java charset {0} to Firebird encoding {1}, already mapped to Firebird encoding {2}", charset.name(), encodingDefinition.getEncoding(), currentEncodingDefinition.getFirebirdEncodingName());
        }
    }

    private Encoding returnEncodingOrFallback(EncodingDefinition encodingDefinition, Encoding fallbackEncoding) {
        if (fallbackEncoding == null) {
            fallbackEncoding = this.getDefaultEncoding();
        }
        if (encodingDefinition == null || encodingDefinition.isInformationOnly()) {
            return fallbackEncoding;
        }
        Encoding encoding = encodingDefinition.getEncoding();
        if (encoding != null) {
            return encoding;
        }
        log.log(System.Logger.Level.DEBUG, "EncodingDefinition for Firebird encoding {0} returned null for getEncoding(), using fallback encoding", encodingDefinition.getFirebirdEncodingName());
        return fallbackEncoding;
    }

    static EncodingFactory getRootEncodingFactory() {
        return DefaultEncodingFactory.ROOT_ENCODING_FACTORY;
    }

    public static IEncodingFactory getPlatformDefault() {
        return DefaultEncodingFactory.PLATFORM_DEFAULT_INSTANCE;
    }

    public static IEncodingFactory createInstance(EncodingDefinition encodingDefinition) {
        if (encodingDefinition == null || encodingDefinition.isInformationOnly()) {
            return EncodingFactory.getPlatformDefault();
        }
        return EncodingFactory.getRootEncodingFactory().withDefaultEncodingDefinition(encodingDefinition);
    }

    public static IEncodingFactory createInstance(Charset charset) {
        if (charset == null) {
            return EncodingFactory.getPlatformDefault();
        }
        return EncodingFactory.getRootEncodingFactory().withDefaultEncodingDefinition(charset);
    }

    private static EncodingFactory createInstance() {
        NavigableSet<EncodingSet> encodingSets = EncodingFactory.loadEncodingSets();
        if (encodingSets.isEmpty()) {
            log.log(System.Logger.Level.WARNING, "No encoding sets were loaded. Make sure at least one valid /META-INF/services/org.firebirdsql.encodings.EncodingSet exists on the classpath (it is normally part of the jaybird jar-file). Falling back to default definition.");
            encodingSets.add(new DefaultEncodingSet());
        }
        return new EncodingFactory(encodingSets.descendingIterator());
    }

    public static EncodingFactory createInstance(EncodingSet ... encodingSets) {
        TreeSet<EncodingSet> sortedEncodingSets = new TreeSet<EncodingSet>(EncodingFactory.encodingSetComparator());
        Collections.addAll(sortedEncodingSets, encodingSets);
        return new EncodingFactory(sortedEncodingSets.descendingIterator());
    }

    private EncodingDefinition resolveEncodingDefinitionByCharset(String charsetAlias) {
        try {
            Charset charset = Charset.forName(charsetAlias);
            return this.getEncodingDefinitionByCharset(charset);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return null;
        }
    }

    private static Set<String> toLowerCaseAliasSet(Charset charset) {
        Set<String> aliases = charset.aliases();
        HashSet<String> potentialNames = new HashSet<String>(aliases.size() + 1);
        potentialNames.add(charset.name().toLowerCase(Locale.ROOT));
        for (String alias : aliases) {
            potentialNames.add(alias.toLowerCase(Locale.ROOT));
        }
        return potentialNames;
    }

    private static Comparator<EncodingSet> encodingSetComparator() {
        return Comparator.comparingInt(EncodingSet::getPreferenceWeight);
    }

    private static class DefaultEncodingFactory {
        private static final EncodingFactory ROOT_ENCODING_FACTORY = EncodingFactory.createInstance();
        private static final IEncodingFactory PLATFORM_DEFAULT_INSTANCE = ROOT_ENCODING_FACTORY.withDefaultEncodingDefinition();

        private DefaultEncodingFactory() {
        }
    }
}

