/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.AbstractGDS;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public class FBSimpleDataSource
implements DataSource,
Serializable,
Referenceable,
FirebirdConnectionProperties {
    protected transient FBManagedConnectionFactory mcf;
    protected transient FBDataSource ds;
    protected transient PrintWriter log;
    protected Reference jndiReference;
    protected String description;
    protected int loginTimeout;

    public FBSimpleDataSource() {
        this(((AbstractGDS)GDSFactory.getDefaultGDS()).getType());
    }

    public FBSimpleDataSource(GDSType type) {
        this.mcf = new FBManagedConnectionFactory(type);
    }

    public Integer getBlobBufferLength() {
        return new Integer(this.mcf.getBlobBufferSize());
    }

    public void setBlobBufferLength(Integer length) {
        this.mcf.setBlobBufferSize(length);
    }

    public String getDatabaseName() {
        return this.getDatabase();
    }

    public void setDatabaseName(String name) {
        this.setDatabase(name);
    }

    public String getDatabase() {
        return this.mcf.getDatabase();
    }

    public void setDatabase(String name) {
        this.mcf.setDatabase(name);
    }

    public String getUser() {
        return this.getUserName();
    }

    public void setUser(String user) {
        this.setUserName(user);
    }

    public String getUserName() {
        return this.mcf.getUserName();
    }

    public void setUserName(String userName) {
        this.mcf.setUserName(userName);
    }

    public String getPassword() {
        return this.mcf.getPassword();
    }

    public void setPassword(String password) {
        this.mcf.setPassword(password);
    }

    public String getEncoding() {
        return this.mcf.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.mcf.setEncoding(encoding);
    }

    public String getTpbMapping() {
        return this.mcf.getTpbMapping();
    }

    public void setTpbMapping(String tpbMapping) {
        this.mcf.setTpbMapping(tpbMapping);
    }

    public int getBlobBufferSize() {
        return this.mcf.getBlobBufferSize();
    }

    public int getBuffersNumber() {
        return this.mcf.getBuffersNumber();
    }

    public String getCharSet() {
        return this.mcf.getCharSet();
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        return this.mcf.getDatabaseParameterBuffer();
    }

    public String getDefaultIsolation() {
        return this.mcf.getDefaultIsolation();
    }

    public int getDefaultTransactionIsolation() {
        return this.mcf.getDefaultTransactionIsolation();
    }

    public String getNonStandardProperty(String key) {
        return this.mcf.getNonStandardProperty(key);
    }

    public String getRoleName() {
        return this.mcf.getRoleName();
    }

    public int getSocketBufferSize() {
        return this.mcf.getSocketBufferSize();
    }

    public String getSqlDialect() {
        return this.mcf.getSqlDialect();
    }

    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.mcf.getTransactionParameters(isolation);
    }

    public String getType() {
        return this.mcf.getType();
    }

    public String getUseTranslation() {
        return this.mcf.getUseTranslation();
    }

    public boolean isTimestampUsesLocalTimezone() {
        return this.mcf.isTimestampUsesLocalTimezone();
    }

    public boolean isUseStandardUdf() {
        return this.mcf.isUseStandardUdf();
    }

    public boolean isUseStreamBlobs() {
        return this.mcf.isUseStreamBlobs();
    }

    public void setBlobBufferSize(int bufferSize) {
        this.mcf.setBlobBufferSize(bufferSize);
    }

    public void setBuffersNumber(int buffersNumber) {
        this.mcf.setBuffersNumber(buffersNumber);
    }

    public void setCharSet(String charSet) {
        this.mcf.setCharSet(charSet);
    }

    public void setDefaultIsolation(String isolation) {
        this.mcf.setDefaultIsolation(isolation);
    }

    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        this.mcf.setDefaultTransactionIsolation(defaultIsolationLevel);
    }

    public void setNonStandardProperty(String key, String value) {
        this.mcf.setNonStandardProperty(key, value);
    }

    public void setNonStandardProperty(String propertyMapping) {
        this.mcf.setNonStandardProperty(propertyMapping);
    }

    public void setRoleName(String roleName) {
        this.mcf.setRoleName(roleName);
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.mcf.setSocketBufferSize(socketBufferSize);
    }

    public void setSqlDialect(String sqlDialect) {
        this.mcf.setSqlDialect(sqlDialect);
    }

    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.mcf.setTimestampUsesLocalTimezone(timestampUsesLocalTimezone);
    }

    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.mcf.setTransactionParameters(isolation, tpb);
    }

    public void setType(String type) {
        this.mcf.setType(type);
    }

    public void setUseStandardUdf(boolean useStandardUdf) {
        this.mcf.setUseStandardUdf(useStandardUdf);
    }

    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.mcf.setUseStreamBlobs(useStreamBlobs);
    }

    public void setUseTranslation(String translationPath) {
        this.mcf.setUseTranslation(translationPath);
    }

    public boolean isDefaultResultSetHoldable() {
        return this.mcf.isDefaultResultSetHoldable();
    }

    public void setDefaultResultSetHoldable(boolean isHoldable) {
        this.mcf.setDefaultResultSetHoldable(isHoldable);
    }

    public Reference getReference() throws NamingException {
        return this.jndiReference;
    }

    public void setReference(Reference reference) {
        this.jndiReference = reference;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDataSource().getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.log;
    }

    public void setLogWriter(PrintWriter log) throws SQLException {
        this.log = log;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected synchronized DataSource getDataSource() throws SQLException {
        if (this.ds != null) {
            return this.ds;
        }
        if (this.mcf.getDatabase() == null || "".equals(this.mcf.getDatabase().trim())) {
            throw new SQLException("Database was not specified. Cannot provide connections.");
        }
        try {
            this.ds = (FBDataSource)this.mcf.createConnectionFactory();
            return this.ds;
        }
        catch (ResourceException rex) {
            throw new SQLException(rex.getMessage());
        }
    }

    public boolean isWrapperFor(Class arg0) throws SQLException {
        return arg0 != null && arg0.isAssignableFrom(FBSimpleDataSource.class);
    }

    public Object unwrap(Class arg0) throws SQLException {
        if (!this.isWrapperFor(arg0)) {
            throw new FBSQLException("No compatible class found.");
        }
        return this;
    }
}

