/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.pool.ConnectionPoolConfiguration;
import org.firebirdsql.pool.PooledConnectionManager;
import org.firebirdsql.pool.PooledConnectionQueue;
import org.firebirdsql.pool.PooledObject;
import org.firebirdsql.pool.PooledObjectEvent;
import org.firebirdsql.pool.PooledObjectListener;
import org.firebirdsql.pool.XPingableConnection;

public abstract class AbstractConnectionPool
implements PooledObjectListener {
    private static final boolean PARANOID_MODE = true;
    private HashMap connectionQueues = new HashMap();
    private HashMap connectionToQueueMap = new HashMap();

    protected abstract Logger getLogger();

    protected AbstractConnectionPool() {
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void restart() {
        for (Map.Entry entry : this.connectionQueues.entrySet()) {
            PooledConnectionQueue queue = (PooledConnectionQueue)entry.getValue();
            queue.restart();
        }
        if (this.getLogger() != null) {
            this.getLogger().info("Pool restarted.  Pool name was " + this.getPoolName() + ".");
        }
    }

    public void shutdown() {
        for (Map.Entry entry : this.connectionQueues.entrySet()) {
            PooledConnectionQueue queue = (PooledConnectionQueue)entry.getValue();
            queue.shutdown();
        }
        if (this.getLogger() != null) {
            this.getLogger().info("Pool shutted down. Pool name was " + this.getPoolName() + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnectionQueue getQueue(Object key) throws SQLException {
        HashMap hashMap = this.connectionQueues;
        synchronized (hashMap) {
            PooledConnectionQueue queue = (PooledConnectionQueue)this.connectionQueues.get(key);
            if (queue == null) {
                queue = new PooledConnectionQueue(this.getConnectionManager(), this.getLogger(), this.getConfiguration(), this.getPoolName(), key);
                queue.start();
                this.connectionQueues.put(key, queue);
            }
            return queue;
        }
    }

    protected synchronized PooledObject getPooledConnection(PooledConnectionQueue queue) throws SQLException {
        PooledObject result = queue.take();
        if (result instanceof XPingableConnection) {
            boolean isValid = false;
            while (!isValid) {
                XPingableConnection pingableConnection = (XPingableConnection)((Object)result);
                long lastPingTime = pingableConnection.getLastPingTime();
                long pingInterval = System.currentTimeMillis() - lastPingTime;
                isValid = true;
                if (this.getConfiguration().getPingInterval() > 0) {
                    isValid &= pingInterval < (long)this.getConfiguration().getPingInterval();
                }
                if (isValid || pingableConnection.ping()) continue;
                if (this.getLogger() != null) {
                    this.getLogger().warn("Connection " + result + " was not valid, trying to get another one.");
                }
                queue.destroyConnection(result);
                result = queue.take();
            }
        }
        this.connectionToQueueMap.put(result, queue);
        return result;
    }

    public void pooledObjectReleased(PooledObjectEvent event) {
        block6: {
            try {
                PooledObject connection = (PooledObject)event.getSource();
                PooledConnectionQueue queue = (PooledConnectionQueue)this.connectionToQueueMap.get(connection);
                if (queue == null) {
                    if (this.getLogger() != null) {
                        this.getLogger().warn("Connection " + connection + " does not have corresponding queue");
                    }
                    this.connectionToQueueMap.remove(connection);
                    throw new IllegalStateException("Connection " + connection + " does not have corresponding queue");
                }
                if (event.isDeallocated()) {
                    this.connectionToQueueMap.remove(connection);
                    queue.physicalConnectionDeallocated(connection);
                } else {
                    queue.put(connection);
                }
            }
            catch (SQLException ex) {
                if (this.getLogger() == null) break block6;
                this.getLogger().warn("Error releasing connection.", ex);
            }
        }
    }

    protected void physicalConnectionDeallocated(PooledObjectEvent event) {
        PooledObject connection = (PooledObject)event.getSource();
        this.connectionToQueueMap.remove(connection);
    }

    public abstract ConnectionPoolConfiguration getConfiguration();

    protected abstract PooledConnectionManager getConnectionManager() throws SQLException;

    protected abstract String getPoolName();

    public abstract int getFreeSize() throws SQLException;

    public abstract int getTotalSize() throws SQLException;

    public abstract int getWorkingSize() throws SQLException;

    protected static class UserPasswordPair {
        private String userName;
        private String password;

        public UserPasswordPair() {
            this(null, null);
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public UserPasswordPair(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof UserPasswordPair)) {
                return false;
            }
            UserPasswordPair that = (UserPasswordPair)obj;
            boolean equal = true;
            equal &= this.userName != null ? this.userName.equals(that.userName) : that.userName == null;
            return equal &= this.password != null ? this.password.equals(that.password) : that.password == null;
        }

        public int hashCode() {
            int result = 3;
            result ^= this.userName != null ? this.userName.hashCode() : 0;
            return result ^= this.password != null ? this.password.hashCode() : 0;
        }
    }
}

