/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.drop.AbstractTableDropBuilder;
import org.apache.metamodel.hbase.HBaseDataContext;
import org.apache.metamodel.hbase.HBaseUpdateCallback;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.Table;

class HBaseTableDropBuilder
extends AbstractTableDropBuilder {
    private final HBaseUpdateCallback _updateCallback;

    public HBaseTableDropBuilder(Table table, HBaseUpdateCallback updateCallback) {
        super(table);
        if (updateCallback.getDataContext().getDefaultSchema().getTableByName(table.getName()) == null) {
            throw new MetaModelException("Trying to delete a table that doesn't exist in the datastore.");
        }
        this._updateCallback = updateCallback;
    }

    public void execute() {
        Table table = this.getTable();
        ((HBaseDataContext)this._updateCallback.getDataContext()).getHBaseClient().dropTable(table.getName());
        ((MutableSchema)table.getSchema()).removeTable(table);
    }
}

