/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.core.IndexerState;
import org.elasticsearch.client.dataframe.transforms.DataFrameTransformProgress;
import org.elasticsearch.client.dataframe.transforms.DataFrameTransformTaskState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameTransformState {
    private static final ParseField INDEXER_STATE = new ParseField("indexer_state", new String[0]);
    private static final ParseField TASK_STATE = new ParseField("task_state", new String[0]);
    private static final ParseField CURRENT_POSITION = new ParseField("current_position", new String[0]);
    private static final ParseField CHECKPOINT = new ParseField("checkpoint", new String[0]);
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    private static final ParseField PROGRESS = new ParseField("progress", new String[0]);
    public static final ConstructingObjectParser<DataFrameTransformState, Void> PARSER = new ConstructingObjectParser("data_frame_transform_state", true, args -> new DataFrameTransformState((DataFrameTransformTaskState)((Object)((Object)args[0])), (IndexerState)((Object)((Object)args[1])), (Map)args[2], (Long)args[3], (String)args[4], (DataFrameTransformProgress)args[5]));
    private final DataFrameTransformTaskState taskState;
    private final IndexerState indexerState;
    private final long checkpoint;
    private final Map<String, Object> currentPosition;
    private final String reason;
    private final DataFrameTransformProgress progress;

    public static DataFrameTransformState fromXContent(XContentParser parser) throws IOException {
        return (DataFrameTransformState)PARSER.parse(parser, null);
    }

    public DataFrameTransformState(DataFrameTransformTaskState taskState, IndexerState indexerState, @Nullable Map<String, Object> position, long checkpoint, @Nullable String reason, @Nullable DataFrameTransformProgress progress) {
        this.taskState = taskState;
        this.indexerState = indexerState;
        this.currentPosition = position == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(position));
        this.checkpoint = checkpoint;
        this.reason = reason;
        this.progress = progress;
    }

    public IndexerState getIndexerState() {
        return this.indexerState;
    }

    public DataFrameTransformTaskState getTaskState() {
        return this.taskState;
    }

    @Nullable
    public Map<String, Object> getPosition() {
        return this.currentPosition;
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Nullable
    public DataFrameTransformProgress getProgress() {
        return this.progress;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformState that = (DataFrameTransformState)other;
        return Objects.equals((Object)this.taskState, (Object)that.taskState) && Objects.equals((Object)this.indexerState, (Object)that.indexerState) && Objects.equals(this.currentPosition, that.currentPosition) && Objects.equals(this.progress, that.progress) && this.checkpoint == that.checkpoint && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskState, this.indexerState, this.currentPosition, this.checkpoint, this.reason, this.progress});
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> DataFrameTransformTaskState.fromString(p.text()), TASK_STATE, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> IndexerState.fromString(p.text()), INDEXER_STATE, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), CURRENT_POSITION, ObjectParser.ValueType.OBJECT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CHECKPOINT);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), DataFrameTransformProgress::fromXContent, PROGRESS, ObjectParser.ValueType.OBJECT);
    }
}

