/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;

public class MethodSerialImpl
implements Serializable {
    public String methodName;
    public String declaringClassName;
    public List<String> paramList;

    public MethodSerialImpl(Method method) {
        this.methodName = method.getName();
        this.declaringClassName = method.getDeclaringClass().getName();
        this.paramList = new ArrayList<String>(method.getParameterTypes().length);
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            this.paramList.add(clazz.getName());
            ++n2;
        }
    }

    public Method convertToMethod(ClassLoader loader) throws NoSuchMethodException {
        Class declaringClass;
        block11: {
            declaringClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        declaringClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.declaringClassName, true, loader));
                        break block11;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.unableToLoadClass((String)this.declaringClassName, (Exception)exception.getException());
                    }
                }
                declaringClass = PrivilegedAccessHelper.getClassForName((String)this.declaringClassName, (boolean)true, (ClassLoader)loader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.unableToLoadClass((String)this.declaringClassName, (Exception)exception);
            }
        }
        Class[] argTypes = new Class[this.paramList.size()];
        int i = 0;
        for (String paramType : this.paramList) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        argTypes[i++] = (Class)AccessController.doPrivileged(new PrivilegedClassForName(paramType, true, loader));
                        continue;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.unableToLoadClass((String)paramType, (Exception)exception.getException());
                    }
                }
                argTypes[i++] = PrivilegedAccessHelper.getClassForName((String)paramType, (boolean)true, (ClassLoader)loader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.unableToLoadClass((String)paramType, (Exception)exception);
            }
        }
        return Helper.getDeclaredMethod((Class)declaringClass, (String)this.methodName, (Class[])argTypes);
    }
}

