/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.junit.Assert;
import org.junit.Test;

public abstract class JGitTestUtil {
    public static final String CLASSPATH_TO_RESOURCES = "org/eclipse/jgit/test/resources/";

    private JGitTestUtil() {
        throw new UnsupportedOperationException();
    }

    public static String getName() {
        try {
            throw new GatherStackTrace();
        }
        catch (GatherStackTrace wanted) {
            GatherStackTrace stack = wanted;
            try {
                StackTraceElement[] stackTraceElementArray = stack.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block8: {
                        Method method;
                        StackTraceElement stackTrace = stackTraceElementArray[n2];
                        String className = stackTrace.getClassName();
                        String methodName = stackTrace.getMethodName();
                        try {
                            method = Class.forName(className).getMethod(methodName, null);
                        }
                        catch (NoSuchMethodException e) {
                            break block8;
                        }
                        Test annotation = method.getAnnotation(Test.class);
                        if (annotation != null) {
                            return methodName;
                        }
                    }
                    ++n2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new AssertionError((Object)"Cannot determine name of current test");
    }

    public static void assertEquals(byte[] exp, byte[] act) {
        Assert.assertEquals((Object)JGitTestUtil.s(exp), (Object)JGitTestUtil.s(act));
    }

    private static String s(byte[] raw) {
        return RawParseUtils.decode((byte[])raw);
    }

    public static File getTestResourceFile(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            return null;
        }
        URL url = JGitTestUtil.cl().getResource(CLASSPATH_TO_RESOURCES + fileName);
        if (url == null) {
            return new File("tst", fileName);
        }
        if ("jar".equals(url.getProtocol())) {
            try {
                File tmp = File.createTempFile("tmp_", "_" + fileName);
                JGitTestUtil.copyTestResource(fileName, tmp);
                return tmp;
            }
            catch (IOException err) {
                throw new RuntimeException("Cannot create temporary file", err);
            }
        }
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(e.getMessage()) + " " + url);
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyTestResource(String name, File dest) throws IOException {
        URL url = JGitTestUtil.cl().getResource(CLASSPATH_TO_RESOURCES + name);
        if (url == null) {
            throw new FileNotFoundException(name);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream in = url.openStream();
            try {
                try (FileOutputStream out = new FileOutputStream(dest);){
                    int n;
                    byte[] buf = new byte[4096];
                    while ((n = in.read(buf)) > 0) {
                        out.write(buf, 0, n);
                    }
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static ClassLoader cl() {
        return JGitTestUtil.class.getClassLoader();
    }

    public static File writeTrashFile(Repository db, String name, String data) throws IOException {
        File path = new File(db.getWorkTree(), name);
        JGitTestUtil.write(path, data);
        return path;
    }

    public static File writeTrashFile(Repository db, String subdir, String name, String data) throws IOException {
        File path = new File(db.getWorkTree() + "/" + subdir, name);
        JGitTestUtil.write(path, data);
        return path;
    }

    public static void write(File f, String body) throws IOException {
        FileUtils.mkdirs((File)f.getParentFile(), (boolean)true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);){
            w.write(body);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String read(File file) throws IOException {
        byte[] body = IO.readFully((File)file);
        return new String(body, 0, body.length, StandardCharsets.UTF_8);
    }

    public static String read(Repository db, String name) throws IOException {
        File file = new File(db.getWorkTree(), name);
        return JGitTestUtil.read(file);
    }

    public static boolean check(Repository db, String name) {
        File file = new File(db.getWorkTree(), name);
        return file.exists();
    }

    public static void deleteTrashFile(Repository db, String name) throws IOException {
        File path = new File(db.getWorkTree(), name);
        FileUtils.delete((File)path);
    }

    public static Path writeLink(Repository db, String link, String target) throws Exception {
        return FileUtils.createSymLink((File)new File(db.getWorkTree(), link), (String)target);
    }

    public static byte[] concat(byte[] ... b) {
        int n = 0;
        byte[][] byArray = b;
        int n2 = b.length;
        int n3 = 0;
        while (n3 < n2) {
            byte[] a = byArray[n3];
            n += a.length;
            ++n3;
        }
        byte[] data = new byte[n];
        n = 0;
        byte[][] byArray2 = b;
        int n4 = b.length;
        n2 = 0;
        while (n2 < n4) {
            byte[] a = byArray2[n2];
            System.arraycopy(a, 0, data, n, a.length);
            n += a.length;
            ++n2;
        }
        return data;
    }

    private static class GatherStackTrace
    extends Exception {
        private GatherStackTrace() {
        }
    }
}

