/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.hitpolicy;

import java.util.List;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.AbstractCollectNumberHitPolicyHandler;
import org.camunda.bpm.dmn.engine.impl.hitpolicy.HitPolicyEntry;
import org.camunda.bpm.model.dmn.BuiltinAggregator;
import org.camunda.bpm.model.dmn.HitPolicy;

public class CollectSumHitPolicyHandler
extends AbstractCollectNumberHitPolicyHandler {
    protected static final HitPolicyEntry HIT_POLICY = new HitPolicyEntry(HitPolicy.COLLECT, BuiltinAggregator.SUM);

    @Override
    public HitPolicyEntry getHitPolicyEntry() {
        return HIT_POLICY;
    }

    @Override
    protected BuiltinAggregator getAggregator() {
        return BuiltinAggregator.SUM;
    }

    @Override
    protected Integer aggregateIntegerValues(List<Integer> intValues) {
        int sum = 0;
        for (Integer intValue : intValues) {
            if (intValue == null) continue;
            sum += intValue.intValue();
        }
        return sum;
    }

    @Override
    protected Long aggregateLongValues(List<Long> longValues) {
        long sum = 0L;
        for (Long longValue : longValues) {
            if (longValue == null) continue;
            sum += longValue.longValue();
        }
        return sum;
    }

    @Override
    protected Double aggregateDoubleValues(List<Double> doubleValues) {
        double sum = 0.0;
        for (Double doubleValue : doubleValues) {
            if (doubleValue == null) continue;
            sum += doubleValue.doubleValue();
        }
        return sum;
    }

    public String toString() {
        return "CollectSumHitPolicyHandler{}";
    }
}

