/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.ValueSetter;
import org.bytedeco.pytorch.LongArrayRef;
import org.bytedeco.pytorch.presets.torch;

@Name(value={"std::vector<c10::ArrayRef<int64_t> >"})
@Properties(inherit={torch.class})
public class LongArrayRefVector
extends Pointer {
    public LongArrayRefVector(Pointer p) {
        super(p);
    }

    public LongArrayRefVector(LongArrayRef value) {
        this(1L);
        this.put(0L, value);
    }

    public LongArrayRefVector(LongArrayRef ... array) {
        this((long)array.length);
        this.put(array);
    }

    public LongArrayRefVector(long ... value) {
        this(1L);
        this.put(0L, value);
    }

    public LongArrayRefVector(long[] ... array) {
        this((long)array.length);
        this.put(array);
    }

    public LongArrayRefVector() {
        this.allocate();
    }

    public LongArrayRefVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native LongArrayRefVector put(@ByRef LongArrayRefVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public LongArrayRef front() {
        return this.get(0L);
    }

    public LongArrayRef back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native LongArrayRef get(@Cast(value={"size_t"}) long var1);

    public native LongArrayRefVector put(@Cast(value={"size_t"}) long var1, LongArrayRef var3);

    @ValueSetter
    @Index(function="at")
    public native LongArrayRefVector put(@Cast(value={"size_t"}) long var1, long ... var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef LongArrayRef var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public LongArrayRef[] get() {
        LongArrayRef[] array = new LongArrayRef[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public LongArrayRef pop_back() {
        long size = this.size();
        LongArrayRef value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public LongArrayRefVector push_back(LongArrayRef value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public LongArrayRefVector put(LongArrayRef value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public LongArrayRefVector put(LongArrayRef ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put((long)i, array[i]);
        }
        return this;
    }

    public LongArrayRefVector push_back(long ... value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public LongArrayRefVector put(long ... value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public LongArrayRefVector put(long[] ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put((long)i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native LongArrayRef get();
    }
}

