/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadView;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadViewMS;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadViewS;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public class FactorySfmMisc {
    public static <T extends ImageBase> CreateSyntheticOverheadView<T> createOverhead(ImageType<T> imageType) {
        Class classType = imageType.getImageClass();
        switch (imageType.getFamily()) {
            case SINGLE_BAND: {
                InterpolatePixelS interp = FactoryInterpolation.bilinearPixelS((Class)classType);
                return new CreateSyntheticOverheadViewS(interp);
            }
            case MULTI_SPECTRAL: {
                return new CreateSyntheticOverheadViewMS(TypeInterpolate.BILINEAR, imageType.getNumBands(), classType);
            }
        }
        throw new IllegalArgumentException(imageType.getFamily() + " is not supported");
    }
}

