/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.robust;

import boofcv.alg.sfm.robust.GenerateAffine2D;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.sfm.ScaleTranslateRotate2D;
import georegression.struct.affine.Affine2D_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class GenerateScaleTranslateRotate2D
implements ModelGenerator<ScaleTranslateRotate2D, AssociatedPair> {
    private Affine2D_F64 affine = new Affine2D_F64();
    private GenerateAffine2D generateAffine = new GenerateAffine2D();
    private DenseMatrix64F R = new DenseMatrix64F(2, 2);
    private DenseMatrix64F U = new DenseMatrix64F(2, 2);
    private DenseMatrix64F V = new DenseMatrix64F(2, 2);
    private SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)2, (int)2, (boolean)true, (boolean)true, (boolean)true);

    public boolean generate(List<AssociatedPair> dataSet, ScaleTranslateRotate2D output) {
        if (!this.generateAffine.generate(dataSet, this.affine)) {
            return false;
        }
        this.R.data[0] = this.affine.a11;
        this.R.data[1] = this.affine.a12;
        this.R.data[2] = this.affine.a21;
        this.R.data[3] = this.affine.a22;
        if (!this.svd.decompose((Matrix64F)this.R)) {
            return false;
        }
        double[] sv = this.svd.getSingularValues();
        output.scale = (sv[0] + sv[1]) / 2.0;
        if (output.scale < 0.0) {
            throw new RuntimeException("Handle this case");
        }
        this.svd.getU((Matrix64F)this.U, false);
        this.svd.getV((Matrix64F)this.V, false);
        CommonOps.multTransB((RowD1Matrix64F)this.U, (RowD1Matrix64F)this.V, (RowD1Matrix64F)this.R);
        if (CommonOps.det((DenseMatrix64F)this.R) < 0.0) {
            for (int i = 0; i < 2; ++i) {
                this.V.set(i, 1, -this.V.get(i, 1));
            }
            CommonOps.mult((RowD1Matrix64F)this.U, (RowD1Matrix64F)this.V, (RowD1Matrix64F)this.R);
        }
        output.theta = Math.atan2(-this.R.data[1], this.R.data[0]);
        output.transX = this.affine.tx;
        output.transY = this.affine.ty;
        return true;
    }

    public int getMinimumPoints() {
        return 3;
    }
}

