/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm;

import boofcv.alg.distort.RemoveRadialPtoN_F64;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;

public abstract class DepthSparse3D<T extends ImageSingleBand> {
    protected T depthImage;
    private RemoveRadialPtoN_F64 p2n = new RemoveRadialPtoN_F64();
    private Point3D_F64 worldPt = new Point3D_F64();
    private Point2D_F64 norm = new Point2D_F64();
    private PixelTransform_F32 visualToDepth;
    private double depthScale;

    public DepthSparse3D(double depthScale) {
        this.depthScale = depthScale;
    }

    public void configure(IntrinsicParameters paramVisual, PixelTransform_F32 visualToDepth) {
        this.visualToDepth = visualToDepth;
        this.p2n.set(paramVisual.fx, paramVisual.fy, paramVisual.skew, paramVisual.cx, paramVisual.cy, paramVisual.radial);
    }

    public void setDepthImage(T depthImage) {
        this.depthImage = depthImage;
    }

    public boolean process(int x, int y) {
        this.visualToDepth.compute(x, y);
        int depthX = (int)this.visualToDepth.distX;
        int depthY = (int)this.visualToDepth.distY;
        if (this.depthImage.isInBounds(depthX, depthY)) {
            double value = this.lookupDepth(depthX, depthY);
            if (value == 0.0) {
                return false;
            }
            this.p2n.compute((double)x, (double)y, this.norm);
            this.worldPt.z = value * this.depthScale;
            this.worldPt.x = this.worldPt.z * this.norm.x;
            this.worldPt.y = this.worldPt.z * this.norm.y;
            return true;
        }
        return false;
    }

    public Point3D_F64 getWorldPt() {
        return this.worldPt;
    }

    protected abstract double lookupDepth(int var1, int var2);

    public static class F32
    extends DepthSparse3D<ImageFloat32> {
        public F32(double depthScale) {
            super(depthScale);
        }

        @Override
        protected double lookupDepth(int depthX, int depthY) {
            return ((ImageFloat32)this.depthImage).unsafe_get(depthX, depthY);
        }
    }

    public static class I<T extends ImageInteger>
    extends DepthSparse3D<T> {
        public I(double depthScale) {
            super(depthScale);
        }

        @Override
        protected double lookupDepth(int depthX, int depthY) {
            return ((ImageInteger)this.depthImage).unsafe_get(depthX, depthY);
        }
    }
}

