/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.io.IOException;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.FormatExpression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.Type;

public final class PlaceholderST
extends Statement {
    public Expression expression;
    public Type type = null;
    FormatExpression format;

    public PlaceholderST(Expression exp, FormatExpression format, GrammarToken token) {
        super(token);
        this.format = format;
        this.expression = exp;
    }

    @Override
    public final void execute(Context ctx) {
        Object value = this.expression.evaluate(ctx);
        try {
            if (this.format != null) {
                value = this.format.evaluateValue(value, ctx);
            }
            if (value != null) {
                if (value.getClass() == String.class) {
                    ctx.byteWriter.writeString((String)value);
                    return;
                }
                if (value instanceof Number) {
                    Class<?> c = value.getClass();
                    if (c == Integer.class) {
                        ctx.byteWriter.writeInteger((Integer)value);
                        return;
                    }
                    if (c == Long.class) {
                        ctx.byteWriter.writeLong((Long)value);
                        return;
                    }
                    if (c == Double.class) {
                        ctx.byteWriter.writeDouble((Double)value);
                        return;
                    }
                    if (c == Float.class) {
                        ctx.byteWriter.writeFloat((Float)value);
                        return;
                    }
                    if (c == Short.class) {
                        ctx.byteWriter.writeShort((Short)value);
                        return;
                    }
                }
                ctx.byteWriter.writeString(value.toString());
            }
        }
        catch (IOException e) {
            BeetlException be = new BeetlException("CLIENT_IO_ERROR_ERROR", e.getMessage(), e);
            be.pushToken(this.token);
            throw be;
        }
    }

    @Override
    public void infer(InferContext inferCtx) {
        this.expression.infer(inferCtx);
        this.type = this.expression.type;
    }
}

