/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.ArrayAA;
import org.beetl.core.om.AttributeAccess;
import org.beetl.core.om.AttributeCodeGen;
import org.beetl.core.om.ListAA;
import org.beetl.core.om.MapAA;
import org.beetl.core.om.MapEntryAA;
import org.beetl.core.om.ObjectAA;
import org.beetl.core.om.ObjectUtil;

public class AttributeAccessFactory {
    static Map<String, AttributeAccess> pojoCache = new ConcurrentHashMap<String, AttributeAccess>();
    static Map<String, AttributeAccess> generalGetCache = new ConcurrentHashMap<String, AttributeAccess>();
    public static MapAA mapAA = new MapAA();
    public static ListAA listAA = new ListAA();
    public static ArrayAA arrayAA = new ArrayAA();
    public static ObjectAA objectAA = new ObjectAA();
    public static MapEntryAA mapEntryAA = new MapEntryAA();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeAccess buildFiledAccessor(Class c, String attrExp) {
        if (c == Object.class) {
            return objectAA;
        }
        if (Map.class.isAssignableFrom(c)) {
            return mapAA;
        }
        if (List.class.isAssignableFrom(c)) {
            return listAA;
        }
        if (c.isArray()) {
            return arrayAA;
        }
        if (c == Map.Entry.class) {
            return mapEntryAA;
        }
        if (c.getName().startsWith("java")) {
            return objectAA;
        }
        String name = attrExp;
        String className = c + "_" + name;
        AttributeAccess aa = pojoCache.get(className);
        if (aa != null) {
            return aa;
        }
        FindResult pojoResult = AttributeAccessFactory.findCommonInterfaceOrClass(c, name);
        if (pojoResult != null) {
            className = pojoResult.c + "_" + name;
            aa = pojoCache.get(className);
            if (aa != null) {
                return aa;
            }
            Class clazz = pojoResult.c;
            synchronized (clazz) {
                aa = pojoCache.get(className);
                if (aa != null) {
                    return aa;
                }
                aa = AttributeCodeGen.createAAClass(pojoResult.c, name, pojoResult.realMethodName, pojoResult.returnType);
                pojoCache.put(className, aa);
                return aa;
            }
        }
        className = c + "_get";
        aa = generalGetCache.get(className);
        if (aa != null) {
            return aa;
        }
        try {
            Method m = c.getMethod("get", String.class);
            Class clazz = c;
            synchronized (clazz) {
                aa = generalGetCache.get(className);
                if (aa != null) {
                    return aa;
                }
                aa = AttributeCodeGen.createAAClass(c, "get", "get", Object.class, String.class);
                generalGetCache.put(className, aa);
                return aa;
            }
        }
        catch (Exception e) {
            BeetlException be = new BeetlException("ATTRIBUTE_NOT_FOUND", name);
            throw be;
        }
    }

    public static FindResult findCommonInterfaceOrClass(Class c, String name) {
        FindResult findResult = AttributeAccessFactory.findResult(c, ObjectUtil.getGetMethod(name), ObjectUtil.getIsMethod(name));
        return findResult;
    }

    private static FindResult findResult(Class c, String getName, String isName) {
        Class<?>[] interfaces;
        FindResult result = null;
        Method[] methods = c.getMethods();
        Method findMethod = null;
        for (Method m : methods) {
            String name = m.getName();
            Class<?>[] paras = m.getParameterTypes();
            if (paras.length != 0) continue;
            if (name.equals(getName)) {
                findMethod = m;
                break;
            }
            if (!name.equals(isName)) continue;
            findMethod = m;
            break;
        }
        for (Class<?> inc : interfaces = c.getInterfaces()) {
            if (!Modifier.isPublic(inc.getModifiers()) || inc.getName().startsWith("java.") || (result = AttributeAccessFactory.findResult(inc, getName, isName)) == null) continue;
            AttributeAccessFactory.resetFindResult(findMethod, result);
            return result;
        }
        Class parent = c.getSuperclass();
        if (parent != null && Modifier.isPublic(parent.getModifiers()) && !parent.getName().startsWith("java.") && (result = AttributeAccessFactory.findResult(parent, getName, isName)) != null) {
            AttributeAccessFactory.resetFindResult(findMethod, result);
            return result;
        }
        if (findMethod != null) {
            result = new FindResult();
            result.realMethodName = findMethod.getName();
            result.c = c;
            result.returnType = findMethod.getReturnType();
            return result;
        }
        return null;
    }

    private static void resetFindResult(Method m, FindResult parent) {
        if (m.getReturnType() == parent.returnType) {
            return;
        }
        parent.returnType = Object.class;
    }

    static class FindResult {
        String realMethodName;
        Class c;
        Class returnType;

        FindResult() {
        }
    }
}

