/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.engine;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.beetl.core.Context;
import org.beetl.core.Event;
import org.beetl.core.InferContext;
import org.beetl.core.Listener;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.misc.NumberUtil;
import org.beetl.core.misc.PrimitiveArrayUtil;
import org.beetl.core.om.AttributeAccess;
import org.beetl.core.om.AttributeAccessFactory;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.Literal;
import org.beetl.core.statement.Type;
import org.beetl.core.statement.VarAttribute;
import org.beetl.core.statement.VarRef;
import org.beetl.core.statement.VarSquareAttribute;
import org.beetl.core.statement.VarVirtualAttribute;

public class VarAttributeNodeListener
implements Listener {
    @Override
    public Object onEvent(Event e) {
        Stack stack = (Stack)e.getEventTaget();
        Object o = stack.peek();
        if (o instanceof VarRef) {
            VarRef ref = (VarRef)o;
            VarAttribute[] attrs = ref.attributes;
            for (int i = 0; i < attrs.length; ++i) {
                Type type;
                VarAttribute attr = attrs[i];
                if (attr.getClass() == VarAttribute.class) {
                    type = attr.type;
                    String name = attr.token != null ? attr.token.text : null;
                    try {
                        AttributeAccess aa;
                        attr.aa = aa = AttributeAccessFactory.buildFiledAccessor(type.cls, name);
                        continue;
                    }
                    catch (BeetlException ex) {
                        ex.pushToken(attr.token);
                        throw ex;
                    }
                }
                if (attr.getClass() == VarSquareAttribute.class) {
                    type = attr.type;
                    Class c = type.cls;
                    if (Map.class.isAssignableFrom(c)) {
                        attr.setAA(AttributeAccessFactory.mapAA);
                        continue;
                    }
                    if (List.class.isAssignableFrom(c) || Set.class.isAssignableFrom(c)) {
                        attr.setAA(AttributeAccessFactory.listAA);
                        continue;
                    }
                    if (c.isArray()) {
                        attr.setAA(AttributeAccessFactory.arrayAA);
                        continue;
                    }
                    Expression exp = ((VarSquareAttribute)attr).exp;
                    if (!(exp instanceof Literal)) continue;
                    Literal literal = (Literal)exp;
                    if (!(literal.obj instanceof String)) continue;
                    try {
                        String attributeName = (String)literal.obj;
                        AttributeAccess aa = AttributeAccessFactory.buildFiledAccessor(c, attributeName);
                        ref.attributes[i] = new VarSquareAttribute2((VarSquareAttribute)attrs[i], attributeName, aa);
                        continue;
                    }
                    catch (BeetlException ex) {
                        ex.pushToken(attr.token);
                        throw ex;
                    }
                }
                if (attr.getClass() != VarVirtualAttribute.class || !attr.token.text.equals("size")) continue;
                Class c = attr.type.cls;
                if (Map.class.isAssignableFrom(c)) {
                    ref.attributes[i] = new MapSizeVirtualAttribute((VarVirtualAttribute)attr);
                    continue;
                }
                if (Collection.class.isAssignableFrom(c)) {
                    ref.attributes[i] = new CollectionSizeVirtualAttribute((VarVirtualAttribute)attr);
                    continue;
                }
                if (!c.isArray()) continue;
                ref.attributes[i] = new ArraySizeVirtualAttribute((VarVirtualAttribute)attr);
            }
        }
        return null;
    }

    class VarSquareAttribute2
    extends VarSquareAttribute {
        String name;

        public VarSquareAttribute2(VarSquareAttribute var, String name, AttributeAccess aa) {
            super(var.exp, var.token);
            this.name = name;
            this.aa = aa;
        }

        @Override
        public Object evaluate(Context ctx, Object o) {
            return this.aa.value(o, this.name);
        }

        @Override
        public void infer(InferContext inferCtx) {
            super.infer(inferCtx);
        }
    }

    class ArraySizeVirtualAttribute
    extends VarVirtualAttribute {
        VarVirtualAttribute old;

        public ArraySizeVirtualAttribute(VarVirtualAttribute old) {
            super(old.token);
            this.old = old;
        }

        @Override
        public Object evaluate(Context ctx, Object o) {
            if (o.getClass().getComponentType().isPrimitive()) {
                return PrimitiveArrayUtil.getSize(o);
            }
            return NumberUtil.valueOf(((Object[])o).length);
        }

        @Override
        public void infer(InferContext inferCtx) {
            super.infer(inferCtx);
        }
    }

    class MapSizeVirtualAttribute
    extends VarVirtualAttribute {
        VarVirtualAttribute old;

        public MapSizeVirtualAttribute(VarVirtualAttribute old) {
            super(old.token);
            this.old = old;
        }

        @Override
        public Object evaluate(Context ctx, Object o) {
            return NumberUtil.valueOf(((Map)o).size());
        }

        @Override
        public void infer(InferContext inferCtx) {
            super.infer(inferCtx);
        }
    }

    class CollectionSizeVirtualAttribute
    extends VarVirtualAttribute {
        VarVirtualAttribute old;

        public CollectionSizeVirtualAttribute(VarVirtualAttribute old) {
            super(old.token);
            this.old = old;
        }

        @Override
        public Object evaluate(Context ctx, Object o) {
            return NumberUtil.valueOf(((Collection)o).size());
        }

        @Override
        public void infer(InferContext inferCtx) {
            super.infer(inferCtx);
        }
    }
}

