/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.h2;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.repository.h2.mapping.BooleanMapping;
import org.b3log.latke.repository.h2.mapping.StringMapping;
import org.b3log.latke.repository.jdbc.AbstractJdbcDatabaseSolution;
import org.b3log.latke.repository.jdbc.mapping.DateMapping;
import org.b3log.latke.repository.jdbc.mapping.IntMapping;
import org.b3log.latke.repository.jdbc.mapping.LongMapping;
import org.b3log.latke.repository.jdbc.mapping.Mapping;
import org.b3log.latke.repository.jdbc.mapping.NumberMapping;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;
import org.b3log.latke.repository.jdbc.util.RepositoryDefinition;

public final class H2JdbcDatabaseSolution
extends AbstractJdbcDatabaseSolution {
    private static final Logger LOGGER = LogManager.getLogger(H2JdbcDatabaseSolution.class);

    public H2JdbcDatabaseSolution() {
        this.registerType("int", (Mapping)new IntMapping());
        this.registerType("boolean", new BooleanMapping());
        this.registerType("long", (Mapping)new LongMapping());
        this.registerType("double", (Mapping)new NumberMapping());
        this.registerType("String", new StringMapping());
        this.registerType("Date", (Mapping)new DateMapping());
    }

    /*
     * Exception decompiling
     */
    public boolean existTable(String tableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String queryPage(int start, int end, String selectSql, String filterSql, String orderBySql, String tableName) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(selectSql).append(" FROM ").append(tableName);
        if (StringUtils.isNotBlank((String)filterSql)) {
            sqlBuilder.append(" WHERE ").append(filterSql);
        }
        sqlBuilder.append(orderBySql);
        sqlBuilder.append(" LIMIT ").append(start).append(",").append(end - start);
        return sqlBuilder.toString();
    }

    public String getRandomlySql(String tableName, int fetchSize) {
        return "SELECT * FROM " + tableName + " ORDER BY RAND() LIMIT " + fetchSize;
    }

    protected void createTableHead(StringBuilder createTableSqlBuilder, RepositoryDefinition repositoryDefinition) {
        createTableSqlBuilder.append("CREATE TABLE IF NOT EXISTS ").append(repositoryDefinition.getName()).append("(");
    }

    protected void createTableBody(StringBuilder createTableSqlBuilder, RepositoryDefinition repositoryDefinition) {
        ArrayList<FieldDefinition> keyDefinitionList = new ArrayList<FieldDefinition>();
        for (FieldDefinition fieldDefinition : repositoryDefinition.getKeys()) {
            String type = fieldDefinition.getType();
            if (type == null) {
                throw new RuntimeException("the type of fieldDefinitions should not be null");
            }
            Mapping mapping = (Mapping)this.getJdbcTypeMapping().get(type);
            if (mapping != null) {
                createTableSqlBuilder.append(mapping.toDataBaseString(fieldDefinition)).append(", ");
                if (!fieldDefinition.getIsKey().booleanValue()) continue;
                keyDefinitionList.add(fieldDefinition);
                continue;
            }
            throw new RuntimeException("The type [" + fieldDefinition.getType() + "] is not register for mapping ");
        }
        this.createSoftDeleteField(createTableSqlBuilder);
        createTableSqlBuilder.append(this.createKeyDefinition(keyDefinitionList));
    }

    private String createKeyDefinition(List<FieldDefinition> keyDefinitionList) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" PRIMARY KEY");
        boolean isFirst = true;
        for (FieldDefinition fieldDefinition : keyDefinitionList) {
            if (isFirst) {
                sqlBuilder.append("(");
                isFirst = false;
            } else {
                sqlBuilder.append(",");
            }
            sqlBuilder.append(fieldDefinition.getName());
        }
        sqlBuilder.append(")");
        return sqlBuilder.toString();
    }

    protected void createTableEnd(StringBuilder createTableSqlBuilder, RepositoryDefinition repositoryDefinition) {
        createTableSqlBuilder.append(")");
    }
}

