/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.data;

import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;

public class Offset<T extends Number> {
    public final T value;

    public static <T extends Number> Offset<T> offset(T value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.doubleValue() >= 0.0, "The value of the offset should be greater than or equal to zero", new Object[0]);
        return new Offset<T>(value);
    }

    private Offset(T value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Offset other = (Offset)obj;
        return Objects.areEqual(this.value, other.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.value);
        return result;
    }

    public String toString() {
        return String.format("%s[value=%s]", this.getClass().getSimpleName(), this.value);
    }
}

