/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractAll$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp[, idx]) - Extract all strings in the `str` that match the `regexp`\n    expression and corresponding to the regex group index.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * idx - an integer expression that representing the group index. The regex may contains\n          multiple groups. `idx` indicates which regex group to extract. The group index should\n          be non-negative. The minimum value of `idx` is 0, which means matching the entire\n          regular expression. If `idx` is not specified, the default group index value is 1. The\n          `idx` parameter is the Java regex Matcher group() method index.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200, 300-400', '(\\\\d+)-(\\\\d+)', 1);\n       [\"100\",\"300\"]\n  ", since="3.1.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0011\"\u0001:B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u00031\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B$\t\u000b=\u0003A\u0011\u0001)\t\u000b=\u0003A\u0011A+\t\u000bi\u0003A\u0011I.\t\u000b\r\u0004A\u0011\t3\t\u000b-\u0004A\u0011\t7\t\u000bU\u0004A\u0011\u000b<\t\u000f\u0005%\u0001\u0001\"\u0015\u0002\f!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003G\u0001\u0011\u0013!C\u0001\u0003KA\u0011\"a\u000f\u0001#\u0003%\t!!\n\t\u0013\u0005u\u0002!%A\u0005\u0002\u0005\u0015\u0002\"CA \u0001\u0005\u0005I\u0011IA!\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0001\u0002^!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003g\u0002\u0011\u0011!C\u0001\u0003kB\u0011\"a \u0001\u0003\u0003%\t%!!\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001du!CAYC\u0005\u0005\t\u0012AAZ\r!\u0001\u0013%!A\t\u0002\u0005U\u0006BB(\u001b\t\u0003\ti\rC\u0005\u0002Pj\t\t\u0011\"\u0012\u0002R\"I\u00111\u001b\u000e\u0002\u0002\u0013\u0005\u0015Q\u001b\u0005\n\u0003;T\u0012\u0011!CA\u0003?D\u0011\"!=\u001b\u0003\u0003%I!a=\u0003!I+w-\u0012=q\u000bb$(/Y2u\u00032d'B\u0001\u0012$\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0011*\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001y3'\u000f\t\u0003aEj\u0011!I\u0005\u0003e\u0005\u0012\u0011CU3h\u000bb\u0004X\t\u001f;sC\u000e$()Y:f!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000f\"\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 .\u0003\u0019a$o\\8u}%\ta'\u0003\u0002Bk\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\tU'A\u0004tk\nTWm\u0019;\u0016\u0003\u001d\u0003\"\u0001\r%\n\u0005%\u000b#AC#yaJ,7o]5p]\u0006A1/\u001e2kK\u000e$\b%\u0001\u0004sK\u001e,\u0007\u0010]\u0001\be\u0016<W\r\u001f9!\u0003\rIG\r_\u0001\u0005S\u0012D\b%\u0001\u0004=S:LGO\u0010\u000b\u0005#J\u001bF\u000b\u0005\u00021\u0001!)Qi\u0002a\u0001\u000f\")1j\u0002a\u0001\u000f\")Qj\u0002a\u0001\u000fR\u0019\u0011K\u0016-\t\u000b]C\u0001\u0019A$\u0002\u0003MDQ!\u0017\u0005A\u0002\u001d\u000b\u0011A]\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u00059~\u0003'\r\u0005\u00025;&\u0011a,\u000e\u0002\u0004\u0003:L\b\"B,\n\u0001\u0004a\u0006\"B1\n\u0001\u0004a\u0016!\u00019\t\u000beK\u0001\u0019\u0001/\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q\u0016\nQ\u0001^=qKNL!A[4\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\u0005i\u0007C\u00018s\u001d\ty\u0007\u000f\u0005\u0002=k%\u0011\u0011/N\u0001\u0007!J,G-\u001a4\n\u0005M$(AB*ue&twM\u0003\u0002rk\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0005ov\f)\u0001\u0005\u0002yw6\t\u0011P\u0003\u0002{C\u000591m\u001c3fO\u0016t\u0017B\u0001?z\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u0002@\r\u0001\u0004y\u0018aA2uqB\u0019\u00010!\u0001\n\u0007\u0005\r\u0011P\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005\u001dA\u00021\u0001x\u0003\t)g/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR9\u0011+!\u0004\u0002\u0012\u0005U\u0001BBA\b\u001b\u0001\u0007q)\u0001\u0005oK^4\u0015N]:u\u0011\u0019\t\u0019\"\u0004a\u0001\u000f\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0007\u0003/i\u0001\u0019A$\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsR9\u0011+!\b\u0002 \u0005\u0005\u0002bB#\u000f!\u0003\u0005\ra\u0012\u0005\b\u0017:\u0001\n\u00111\u0001H\u0011\u001die\u0002%AA\u0002\u001d\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002()\u001aq)!\u000b,\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000e6\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\tyCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\nAA[1wC&\u00191/a\u0012\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0003c\u0001\u001b\u0002X%\u0019\u0011\u0011L\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007q\u000by\u0006C\u0005\u0002bQ\t\t\u00111\u0001\u0002V\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001a\u0011\u000b\u0005%\u0014q\u000e/\u000e\u0005\u0005-$bAA7k\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00141\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002x\u0005u\u0004c\u0001\u001b\u0002z%\u0019\u00111P\u001b\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\r\f\u0002\u0002\u0003\u0007A,\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\"\u0003\u0007C\u0011\"!\u0019\u0018\u0003\u0003\u0005\r!!\u0016\u0002\r\u0015\fX/\u00197t)\u0011\t9(!#\t\u0011\u0005\u0005\u0004$!AA\u0002qCs\u0003AAG\u0003'\u000b)*!'\u0002\u001c\u0006}\u0015\u0011UAS\u0003O\u000bY+!,\u0011\u0007A\ny)C\u0002\u0002\u0012\u0006\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0018\u0006\t\tD\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO\u001d\u0017!e\u0016<W\r\u001f9\\Y\u0001JG\r_/*A5\u0002S\t\u001f;sC\u000e$\b%\u00197mAM$(/\u001b8hg\u0002Jg\u000e\t;iK\u0002\u00027\u000f\u001e:aAQD\u0017\r\u001e\u0011nCR\u001c\u0007\u000e\t;iK\u0002\u0002'/Z4fqB\u0004'\u0002\t\u0011!A\u0015D\bO]3tg&|g\u000eI1oI\u0002\u001awN\u001d:fgB|g\u000eZ5oO\u0002\"x\u000e\t;iK\u0002\u0012XmZ3yA\u001d\u0014x.\u001e9!S:$W\r\u001f\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005u\u0015\u0001c1\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHO\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u0012XmZ3ya\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011sKB\u0014Xm]3oi&tw\rI1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gN\f\u0011UQ\u0016\u0004#/Z4fq\u0002\u001aHO]5oO\u0002\u001a\bn\\;mI\u0002\u0012W\rI1\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#*\u0019<bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018=EJtDH\u0019:?\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003eU5oG\u0016\u00043\u000b]1sW\u0002\u0012d\u0006\r\u0017!gR\u0014\u0018N\\4!Y&$XM]1mg\u0002B\u0013N\\2mk\u0012Lgn\u001a\u0011sK\u001e,\u0007\u0010\t9biR,'O\\:*A\u0005\u0014X\rI;oKN\u001c\u0017\r]3eA%t\u0007e\\;sAM\u000bFJ\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AA\f'o]3s]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-AQ|\u0007%\\1uG\"\u0004#\u0005X1cG\nb\u0003%\u0019\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t\u0007EZ8sA\u0001\u0014XmZ3ya\u0002\u00043-\u00198!E\u0016T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011#=rc\u0016MY2%E9b$M\u001d =EJt$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!)\",'/\u001a\u0011jg\u0002\n\u0007eU)MA\r|gNZ5hA\u001d\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u0014!i\"\fG\u000fI2b]\u0002\u0012W\rI;tK\u0012\u0004Co\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012\u0017\r\u001c7cC\u000e\\\u0007\u0005^8!i\",\u0007e\u00159be.\u0004\u0013G\f\u001c!E\u0016D\u0017M^5pe\u0002\u0012XmZ1sI&tw\rI:ue&tw\r\t7ji\u0016\u0014\u0018\r\u001c\u0011qCJ\u001c\u0018N\\4/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013N\u001a\u0011uQ\u0016\u00043m\u001c8gS\u001e\u0004\u0013n\u001d\u0011f]\u0006\u0014G.\u001a3-AQDW\r\t1sK\u001e,\u0007\u0010\u001d1!i\"\fG\u000fI2b]\u0002j\u0017\r^2iA\tb\u0016MY2#A%\u001c\bE\t0]C\n\u001cGE\t\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A%$\u0007\u0010I\u0017!C:\u0004\u0013N\u001c;fO\u0016\u0014\b%\u001a=qe\u0016\u001c8/[8oAQD\u0017\r\u001e\u0011sKB\u0014Xm]3oi&tw\r\t;iK\u0002:'o\\;qA%tG-\u001a=/AQCW\r\t:fO\u0016D\b%\\1zA\r|g\u000e^1j]NT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011nk2$\u0018\u000e\u001d7fA\u001d\u0014x.\u001e9t]\u0001\u0002\u0017\u000e\u001a=aA%tG-[2bi\u0016\u001c\be\u001e5jG\"\u0004#/Z4fq\u0002:'o\\;qAQ|\u0007%\u001a=ue\u0006\u001cGO\f\u0011UQ\u0016\u0004sM]8va\u0002Jg\u000eZ3yAMDw.\u001e7e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EY3!]>tWF\\3hCRLg/\u001a\u0018!)\",\u0007%\\5oS6,X\u000e\t<bYV,\u0007e\u001c4!A&$\u0007\u0010\u0019\u0011jg\u0002\u0002D\u0006I<iS\u000eD\u0007%\\3b]N\u0004S.\u0019;dQ&tw\r\t;iK\u0002*g\u000e^5sK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:t\u0003%\u00134!A&$\u0007\u0010\u0019\u0011jg\u0002rw\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI2\u0002C\u000f[3!I\u00164\u0017-\u001e7uA\u001d\u0014x.\u001e9!S:$W\r\u001f\u0011wC2,X\rI5tAEr\u0003\u0005\u00165f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005Y5eq\u0002\u0004\u0003/\u0019:b[\u0016$XM\u001d\u0011jg\u0002\"\b.\u001a\u0011KCZ\f\u0007E]3hKb\u0004S*\u0019;dQ\u0016\u0014\be\u001a:pkBD\u0013\u0006I7fi\"|G\rI5oI\u0016DhF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAR\u0003\u0015T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u00191a5\u0012\u0004\u0007\r\u0017!gA\u0002T\u0006\u000e\u00191O1\u0002s\u0005\u000b/]I.JS\u0006\u000b/]I.Js\u0005\f\u00112SmR\u0001\u0005\t\u0011!A\u0001\u00023LI\u00191a\tb#e\r\u00191EuS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003S\u000bQa\r\u00182]A\nQa\u001a:pkB\f#!a,\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002!I+w-\u0012=q\u000bb$(/Y2u\u00032d\u0007C\u0001\u0019\u001b'\u0015Q\u0012qWAb!!\tI,a0H\u000f\u001e\u000bVBAA^\u0015\r\ti,N\u0001\beVtG/[7f\u0013\u0011\t\t-a/\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0002F\u0006-WBAAd\u0015\u0011\tI-a\u0013\u0002\u0005%|\u0017bA\"\u0002HR\u0011\u00111W\u0001\ti>\u001cFO]5oOR\u0011\u00111I\u0001\u0006CB\u0004H.\u001f\u000b\b#\u0006]\u0017\u0011\\An\u0011\u0015)U\u00041\u0001H\u0011\u0015YU\u00041\u0001H\u0011\u0015iU\u00041\u0001H\u0003\u001d)h.\u00199qYf$B!!9\u0002nB)A'a9\u0002h&\u0019\u0011Q]\u001b\u0003\r=\u0003H/[8o!\u0019!\u0014\u0011^$H\u000f&\u0019\u00111^\u001b\u0003\rQ+\b\u000f\\34\u0011!\tyOHA\u0001\u0002\u0004\t\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u001f\t\u0005\u0003\u000b\n90\u0003\u0003\u0002z\u0006\u001d#AB(cU\u0016\u001cG\u000f")
public class RegExpExtractAll
extends RegExpExtractBase
implements Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtractAll x$0) {
        return RegExpExtractAll$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpExtractAll> tupled() {
        return RegExpExtractAll$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpExtractAll>>> curried() {
        return RegExpExtractAll$.MODULE$.curried();
    }

    @Override
    public Expression subject() {
        return this.subject;
    }

    @Override
    public Expression regexp() {
        return this.regexp;
    }

    @Override
    public Expression idx() {
        return this.idx;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        Matcher m = this.getLastMatcher(s, p);
        ArrayBuffer matchResults = new ArrayBuffer();
        while (m.find()) {
            MatchResult mr = m.toMatchResult();
            int index = BoxesRunTime.unboxToInt((Object)r);
            RegExpExtractBase$.MODULE$.checkGroupIndex(mr.groupCount(), index);
            String group = mr.group(index);
            Growable growable = group == null ? matchResults.$plus$eq((Object)UTF8String.EMPTY_UTF8) : matchResults.$plus$eq((Object)UTF8String.fromString((String)group));
        }
        return new GenericArrayData((Object[])matchResults.toArray(ClassTag$.MODULE$.apply(UTF8String.class)));
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    @Override
    public String prettyName() {
        return "regexp_extract_all";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNameRegExpExtractBase = RegExpExtractBase.class.getCanonicalName();
        String arrayClass = GenericArrayData.class.getName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String matchResults = ctx.freshName("matchResults");
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(subject, regexp, idx) -> new StringBuilder(499).append("\n         | ").append(this.initLastMatcherCode(ctx, (String)subject, (String)regexp, matcher)).append("\n         | java.util.ArrayList ").append(matchResults).append(" = new java.util.ArrayList<UTF8String>();\n         | while (").append(matcher).append(".find()) {\n         |   java.util.regex.MatchResult ").append(matchResult).append(" = ").append(matcher).append(".toMatchResult();\n         |   ").append(classNameRegExpExtractBase).append(".checkGroupIndex(").append(matchResult).append(".groupCount(), ").append((String)idx).append(");\n         |   if (").append(matchResult).append(".group(").append((String)idx).append(") == null) {\n         |     ").append(matchResults).append(".add(UTF8String.EMPTY_UTF8);\n         |   } else {\n         |     ").append(matchResults).append(".add(UTF8String.fromString(").append(matchResult).append(".group(").append((String)idx).append(")));\n         |   }\n         | }\n         | ").append(ev.value()).append(" =\n         |   new ").append(arrayClass).append("(").append(matchResults).append(".toArray(new UTF8String[").append(matchResults).append(".size()]));\n         | ").append(setEvNotNull).append("\n         ").toString());
    }

    @Override
    public RegExpExtractAll withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public RegExpExtractAll copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtractAll(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtractAll";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.subject();
                break;
            }
            case 1: {
                object = this.regexp();
                break;
            }
            case 2: {
                object = this.idx();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtractAll;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "subject";
                break;
            }
            case 1: {
                string = "regexp";
                break;
            }
            case 2: {
                string = "idx";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtractAll)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtractAll regExpExtractAll = (RegExpExtractAll)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtractAll.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtractAll.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtractAll.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtractAll.canEqual(this)) return false;
        return true;
    }

    public RegExpExtractAll(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
    }

    public RegExpExtractAll(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

