/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.resultset;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;

public final class ShardingSphereResultSetUtils {
    public static Map<String, Integer> createColumnLabelAndIndexMap(SQLStatementContext sqlStatementContext, boolean selectContainsEnhancedTable, ResultSetMetaData resultSetMetaData) throws SQLException {
        if (selectContainsEnhancedTable && ShardingSphereResultSetUtils.hasSelectExpandProjections(sqlStatementContext)) {
            return ShardingSphereResultSetUtils.createColumnLabelAndIndexMapWithExpandProjections((SelectStatementContext)sqlStatementContext);
        }
        CaseInsensitiveMap result = new CaseInsensitiveMap(resultSetMetaData.getColumnCount(), 1.0f);
        for (int columnIndex = resultSetMetaData.getColumnCount(); columnIndex > 0; --columnIndex) {
            result.put(resultSetMetaData.getColumnLabel(columnIndex), columnIndex);
        }
        return result;
    }

    private static Map<String, Integer> createColumnLabelAndIndexMapWithExpandProjections(SelectStatementContext statementContext) {
        List actualProjections = statementContext.getProjectionsContext().getExpandProjections();
        CaseInsensitiveMap result = new CaseInsensitiveMap(actualProjections.size(), 1.0f);
        for (int columnIndex = actualProjections.size(); columnIndex > 0; --columnIndex) {
            Projection projection = (Projection)actualProjections.get(columnIndex - 1);
            result.put(DerivedColumn.isDerivedColumnName((String)projection.getColumnLabel()) ? projection.getExpression() : projection.getColumnLabel(), columnIndex);
        }
        return result;
    }

    private static boolean hasSelectExpandProjections(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !((SelectStatementContext)sqlStatementContext).getProjectionsContext().getExpandProjections().isEmpty();
    }

    @Generated
    private ShardingSphereResultSetUtils() {
    }
}

