/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process;

import java.util.Collections;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteIDContext;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessReporter;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessStatusEnum;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.MySQLStatement;

public final class ExecuteProcessEngine {
    private final ExecuteProcessReporter reporter = new ExecuteProcessReporter();

    public String initializeConnection(Grantee grantee, String databaseName) {
        ExecutionGroupContext<SQLExecutionUnit> executionGroupContext = this.createExecutionGroupContext(grantee, databaseName);
        this.reporter.report(executionGroupContext);
        return executionGroupContext.getReportContext().getExecutionID();
    }

    private ExecutionGroupContext<SQLExecutionUnit> createExecutionGroupContext(Grantee grantee, String databaseName) {
        return new ExecutionGroupContext<SQLExecutionUnit>(Collections.emptyList(), new ExecutionGroupReportContext(databaseName, grantee));
    }

    public void finishConnection(String executionID) {
        this.reporter.reportRemove(executionID);
    }

    public void initializeExecution(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, QueryContext queryContext) {
        if (this.isMySQLDDLOrDMLStatement(queryContext.getSqlStatementContext().getSqlStatement())) {
            ExecuteIDContext.set(executionGroupContext.getReportContext().getExecutionID());
            this.reporter.report(queryContext, executionGroupContext, ExecuteProcessStatusEnum.START);
        }
    }

    public void finishExecution(SQLExecutionUnit executionUnit) {
        if (ExecuteIDContext.isEmpty()) {
            return;
        }
        this.reporter.report(ExecuteIDContext.get(), executionUnit, ExecuteProcessStatusEnum.DONE);
    }

    public void cleanExecution() {
        if (ExecuteIDContext.isEmpty()) {
            return;
        }
        this.reporter.reportClean(ExecuteIDContext.get());
        ExecuteIDContext.remove();
    }

    private boolean isMySQLDDLOrDMLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof MySQLStatement && (sqlStatement instanceof DDLStatement || sqlStatement instanceof DMLStatement);
    }
}

