/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteIDContext;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;

public final class RawSQLExecutorCallback
implements ExecutorCallback<RawSQLExecutionUnit, ExecuteResult> {
    private final Collection<RawExecutorCallback> callbacks = ShardingSphereServiceLoader.getServiceInstances(RawExecutorCallback.class);

    public RawSQLExecutorCallback() {
        Preconditions.checkState((!this.callbacks.isEmpty() ? 1 : 0) != 0, (Object)"No raw executor callback implementation found.");
    }

    @Override
    public Collection<ExecuteResult> execute(Collection<RawSQLExecutionUnit> inputs, boolean isTrunkThread) throws SQLException {
        Collection<ExecuteResult> result = this.callbacks.iterator().next().execute(inputs, isTrunkThread);
        if (!ExecuteIDContext.isEmpty()) {
            ExecuteProcessEngine executeProcessEngine = new ExecuteProcessEngine();
            for (RawSQLExecutionUnit each : inputs) {
                executeProcessEngine.finishExecution(each);
            }
        }
        return result;
    }
}

