/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.sqlparser.druid.oracle;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.sqlparser.ParametersHolder;
import org.apache.seata.sqlparser.druid.BaseRecognizer;
import org.apache.seata.sqlparser.struct.Null;

public abstract class BaseOracleRecognizer
extends BaseRecognizer {
    public BaseOracleRecognizer(String originalSql) {
        super(originalSql);
    }

    public OracleOutputVisitor createOutputVisitor(final ParametersHolder parametersHolder, final ArrayList<List<Object>> paramAppenderList, StringBuilder sb) {
        return new OracleOutputVisitor(sb){

            public boolean visit(SQLVariantRefExpr x) {
                if ("?".equals(x.getName())) {
                    ArrayList<Object> oneParamValues = parametersHolder.getParameters().get(x.getIndex() + 1);
                    if (paramAppenderList.isEmpty()) {
                        oneParamValues.forEach(t -> paramAppenderList.add(new ArrayList()));
                    }
                    for (int i = 0; i < oneParamValues.size(); ++i) {
                        Object o = oneParamValues.get(i);
                        ((List)paramAppenderList.get(i)).add(o instanceof Null ? null : o);
                    }
                }
                return super.visit(x);
            }
        };
    }

    public String getWhereCondition(SQLExpr where, ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        if (Objects.isNull(where)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeVisit(where, (SQLASTVisitor)this.createOutputVisitor(parametersHolder, paramAppenderList, sb));
        return sb.toString();
    }

    public String getWhereCondition(SQLExpr where) {
        if (Objects.isNull(where)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeVisit(where, (SQLASTVisitor)new OracleOutputVisitor((Appendable)sb));
        return sb.toString();
    }

    protected String getOrderByCondition(SQLOrderBy sqlOrderBy) {
        if (Objects.isNull(sqlOrderBy)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeOrderBy(sqlOrderBy, (SQLASTVisitor)new OracleOutputVisitor((Appendable)sb));
        return sb.toString();
    }

    protected String getOrderByCondition(SQLOrderBy sqlOrderBy, ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        if (Objects.isNull(sqlOrderBy)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeOrderBy(sqlOrderBy, (SQLASTVisitor)this.createOutputVisitor(parametersHolder, paramAppenderList, sb));
        return sb.toString();
    }

    @Override
    public boolean isSqlSyntaxSupports() {
        OracleASTVisitorAdapter visitor = new OracleASTVisitorAdapter(){

            public boolean visit(OracleSelectJoin x) {
                throw new NotSupportYetException("not support the sql syntax with join table:" + x + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
            }

            public boolean visit(OracleUpdateStatement x) {
                if (x.getTableSource() instanceof OracleSelectSubqueryTableSource) {
                    throw new NotSupportYetException("not support the sql syntax with join table:" + x + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
                }
                List updateSetItems = x.getItems();
                for (SQLUpdateSetItem updateSetItem : updateSetItems) {
                    if (!(updateSetItem.getValue() instanceof SQLQueryExpr)) continue;
                    throw new NotSupportYetException("not support the sql syntax with join table:" + x + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
                }
                return true;
            }

            public boolean visit(SQLInSubQueryExpr x) {
                throw new NotSupportYetException("not support the sql syntax with InSubQuery:" + x + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
            }

            public boolean visit(OracleSelectSubqueryTableSource x) {
                throw new NotSupportYetException("not support the sql syntax with SubQuery:" + x + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
            }

            public boolean visit(SQLInsertStatement x) {
                if (null != x.getQuery()) {
                    throw new NotSupportYetException("not support the sql syntax insert with query:" + x + "\nplease see the doc about SQL restrictions https://seata.apache.org/zh-cn/docs/user/sqlreference/dml");
                }
                return true;
            }
        };
        this.getAst().accept((SQLASTVisitor)visitor);
        return true;
    }

    public String getDbType() {
        return "oracle";
    }
}

