/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.rm.interceptor.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.core.model.Resource;
import org.apache.seata.integration.tx.api.interceptor.ActionContextUtil;
import org.apache.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import org.apache.seata.integration.tx.api.interceptor.parser.IfNeedEnhanceBean;
import org.apache.seata.integration.tx.api.interceptor.parser.InterfaceParser;
import org.apache.seata.integration.tx.api.interceptor.parser.NeedEnhanceEnum;
import org.apache.seata.integration.tx.api.remoting.parser.DefaultRemotingParser;
import org.apache.seata.rm.DefaultResourceManager;
import org.apache.seata.saga.rm.SagaAnnotationResource;
import org.apache.seata.saga.rm.api.CompensationBusinessAction;
import org.apache.seata.saga.rm.interceptor.SagaAnnotationActionInterceptorHandler;

public class SagaAnnotationActionInterceptorParser
implements InterfaceParser {
    @Override
    public ProxyInvocationHandler parserInterfaceToProxy(Object target, String objectName) {
        Map<Method, Class<?>> methodClassMap = ReflectionUtil.findMatchMethodClazzMap(target.getClass(), method -> method.isAnnotationPresent(this.getAnnotationClass()));
        Set<Method> methodsToProxy = methodClassMap.keySet();
        if (methodsToProxy.isEmpty()) {
            return null;
        }
        this.registerResource(target, methodClassMap);
        return new SagaAnnotationActionInterceptorHandler(target, methodsToProxy.stream().map(Method::getName).collect(Collectors.toSet()));
    }

    private void registerResource(Object target, Map<Method, Class<?>> methodClassMap) {
        try {
            for (Map.Entry<Method, Class<?>> methodClassEntry : methodClassMap.entrySet()) {
                Method method = methodClassEntry.getKey();
                Annotation annotation = method.getAnnotation(this.getAnnotationClass());
                if (annotation == null) continue;
                Resource resource = this.createResource(target, methodClassEntry.getValue(), annotation);
                DefaultResourceManager.get().registerResource(resource);
            }
        }
        catch (Throwable t) {
            throw new FrameworkException(t, "register SagaAnnotation resource error");
        }
    }

    @Override
    public IfNeedEnhanceBean parseIfNeedEnhancement(Class<?> beanClass) {
        IfNeedEnhanceBean ifNeedEnhanceBean = new IfNeedEnhanceBean();
        if (DefaultRemotingParser.get().isService(beanClass)) {
            ifNeedEnhanceBean.setIfNeed(true);
            ifNeedEnhanceBean.setNeedEnhanceEnum(NeedEnhanceEnum.SERVICE_BEAN);
        }
        return ifNeedEnhanceBean;
    }

    protected Class<? extends Annotation> getAnnotationClass() {
        return CompensationBusinessAction.class;
    }

    protected Resource createResource(Object targetBean, Class<?> serviceClass, Annotation annotation) throws NoSuchMethodException {
        CompensationBusinessAction compensationBusinessAction = (CompensationBusinessAction)annotation;
        SagaAnnotationResource sagaAnnotationResource = new SagaAnnotationResource();
        sagaAnnotationResource.setActionName(compensationBusinessAction.name());
        sagaAnnotationResource.setTargetBean(targetBean);
        sagaAnnotationResource.setCompensationMethodName(compensationBusinessAction.compensationMethod());
        Method compensationMethod = serviceClass.getMethod(compensationBusinessAction.compensationMethod(), compensationBusinessAction.compensationArgsClasses());
        sagaAnnotationResource.setCompensationMethod(compensationMethod);
        sagaAnnotationResource.setCompensationArgsClasses(compensationBusinessAction.compensationArgsClasses());
        sagaAnnotationResource.setPhaseTwoCompensationKeys(ActionContextUtil.getTwoPhaseArgs(sagaAnnotationResource.getCompensationMethod(), compensationBusinessAction.compensationArgsClasses()));
        return sagaAnnotationResource;
    }
}

