/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.utils;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.statelang.domain.StateInstance;
import org.apache.seata.saga.statelang.domain.StateMachineInstance;

public class ExceptionUtils {
    public static final String CONNECT_TIMED_OUT = "connect timed out";
    public static final String CONNECT_TIME_OUT_EXCEPTION_CLASS_NAME = "ConnectTimeoutException";
    public static final String READ_TIME_OUT_EXCEPTION_CLASS_NAME = "ReadTimeoutException";
    public static final String CONNECT_EXCEPTION_CLASS_NAME = "ConnectException";
    public static final int MAX_CAUSE_DEP = 20;

    public static EngineExecutionException createEngineExecutionException(Exception e, FrameworkErrorCode code, String message, StateMachineInstance stateMachineInstance, StateInstance stateInstance) {
        EngineExecutionException exception = new EngineExecutionException(e, message, code);
        if (stateMachineInstance != null) {
            exception.setStateMachineName(stateMachineInstance.getStateMachine().getAppName());
            exception.setStateMachineInstanceId(stateMachineInstance.getId());
            if (stateInstance != null) {
                exception.setStateName(stateInstance.getName());
                exception.setStateInstanceId(stateInstance.getId());
            }
        }
        return exception;
    }

    public static EngineExecutionException createEngineExecutionException(FrameworkErrorCode code, String message, StateMachineInstance stateMachineInstance, StateInstance stateInstance) {
        return ExceptionUtils.createEngineExecutionException(null, code, message, stateMachineInstance, stateInstance);
    }

    public static EngineExecutionException createEngineExecutionException(Exception e, FrameworkErrorCode code, String message, StateMachineInstance stateMachineInstance, String stateName) {
        EngineExecutionException exception = new EngineExecutionException(e, message, code);
        if (stateMachineInstance != null) {
            exception.setStateMachineName(stateMachineInstance.getStateMachine().getAppName());
            exception.setStateMachineInstanceId(stateMachineInstance.getId());
            exception.setStateName(stateName);
        }
        return exception;
    }

    public static NetExceptionType getNetExceptionType(Throwable throwable) {
        Throwable currentCause = throwable;
        for (int dep = 20; currentCause != null && dep > 0; --dep) {
            if (currentCause instanceof SocketTimeoutException) {
                if (CONNECT_TIMED_OUT.equals(currentCause.getMessage())) {
                    return NetExceptionType.CONNECT_TIMEOUT_EXCEPTION;
                }
                return NetExceptionType.READ_TIMEOUT_EXCEPTION;
            }
            if (currentCause instanceof ConnectException) {
                return NetExceptionType.CONNECT_EXCEPTION;
            }
            if (currentCause.getClass().getSimpleName().contains(CONNECT_TIME_OUT_EXCEPTION_CLASS_NAME)) {
                return NetExceptionType.CONNECT_TIMEOUT_EXCEPTION;
            }
            if (currentCause.getClass().getSimpleName().contains(READ_TIME_OUT_EXCEPTION_CLASS_NAME)) {
                return NetExceptionType.READ_TIMEOUT_EXCEPTION;
            }
            if (currentCause.getClass().getSimpleName().contains(CONNECT_EXCEPTION_CLASS_NAME)) {
                return NetExceptionType.CONNECT_EXCEPTION;
            }
            Throwable parentCause = currentCause.getCause();
            if (parentCause == null || parentCause == currentCause) break;
            currentCause = parentCause;
        }
        return NetExceptionType.NOT_NET_EXCEPTION;
    }

    public static boolean isNetException(Throwable throwable) {
        NetExceptionType netExceptionType = ExceptionUtils.getNetExceptionType(throwable);
        return netExceptionType != NetExceptionType.NOT_NET_EXCEPTION;
    }

    public static enum NetExceptionType {
        CONNECT_EXCEPTION,
        CONNECT_TIMEOUT_EXCEPTION,
        READ_TIMEOUT_EXCEPTION,
        NOT_NET_EXCEPTION;

    }
}

