/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.xa;

import java.io.UnsupportedEncodingException;
import org.apache.seata.rm.datasource.xa.XAXid;

public class XABranchXid
implements XAXid {
    private static final String DEFAULT_ENCODE_CHARSET = "UTF-8";
    private static final String BRANCH_ID_PREFIX = "-";
    private static final int SEATA_XA_XID_FORMAT_ID = 9752;
    private String xid;
    private long branchId;
    private byte[] globalTransactionId;
    private byte[] branchQualifier;

    XABranchXid(String xid, long branchId) {
        this.xid = xid;
        this.branchId = branchId;
        this.encode();
    }

    XABranchXid(byte[] globalTransactionId, byte[] branchQualifier) {
        this.globalTransactionId = globalTransactionId;
        this.branchQualifier = branchQualifier;
        this.decode();
    }

    @Override
    public String getGlobalXid() {
        return this.xid;
    }

    @Override
    public long getBranchId() {
        return this.branchId;
    }

    @Override
    public int getFormatId() {
        return 9752;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    private byte[] string2byteArray(String string) {
        try {
            return string.getBytes(DEFAULT_ENCODE_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String byteArray2String(byte[] bytes) {
        try {
            return new String(bytes, DEFAULT_ENCODE_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void encode() {
        this.globalTransactionId = this.xid == null ? new byte[0] : this.string2byteArray(this.xid);
        this.branchQualifier = this.branchId == 0L ? new byte[0] : this.string2byteArray(BRANCH_ID_PREFIX + this.branchId);
    }

    private void decode() {
        this.xid = this.globalTransactionId == null || this.globalTransactionId.length == 0 ? null : this.byteArray2String(this.globalTransactionId);
        if (this.branchQualifier == null || this.branchQualifier.length == 0) {
            this.branchId = 0L;
        } else {
            String bs = this.byteArray2String(this.branchQualifier).substring(BRANCH_ID_PREFIX.length());
            this.branchId = Long.parseLong(bs);
        }
    }

    public String toString() {
        return this.xid + BRANCH_ID_PREFIX + this.branchId;
    }
}

