/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.parser;

import io.protostuff.Input;
import io.protostuff.LinkedBuffer;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.WireFormat;
import io.protostuff.runtime.DefaultIdStrategy;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.RuntimeEnv;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.apache.seata.common.executor.Initialize;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.EnhancedServiceNotFoundException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.BufferUtils;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.rm.datasource.undo.BranchUndoLog;
import org.apache.seata.rm.datasource.undo.UndoLogParser;
import org.apache.seata.rm.datasource.undo.parser.spi.ProtostuffDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="protostuff")
public class ProtostuffUndoLogParser
implements UndoLogParser,
Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtostuffUndoLogParser.class);
    public static final String NAME = "protostuff";
    private final DefaultIdStrategy idStrategy = (DefaultIdStrategy)RuntimeEnv.ID_STRATEGY;
    private final Schema<BranchUndoLog> schema = RuntimeSchema.getSchema(BranchUndoLog.class, (IdStrategy)this.idStrategy);

    @Override
    public void init() {
        try {
            List<ProtostuffDelegate> delegates = EnhancedServiceLoader.loadAll(ProtostuffDelegate.class);
            if (CollectionUtils.isNotEmpty(delegates)) {
                for (ProtostuffDelegate delegate : delegates) {
                    this.idStrategy.registerDelegate(delegate.create());
                    LOGGER.info("protostuff undo log parser load [{}].", (Object)delegate.getClass().getName());
                }
            }
        }
        catch (EnhancedServiceNotFoundException e) {
            LOGGER.warn("ProtostuffDelegate not found children class.", (Throwable)((Object)e));
        }
        this.idStrategy.registerDelegate((Delegate)new DateDelegate());
        this.idStrategy.registerDelegate((Delegate)new TimestampDelegate());
        this.idStrategy.registerDelegate((Delegate)new SqlDateDelegate());
        this.idStrategy.registerDelegate((Delegate)new TimeDelegate());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        return this.encode(new BranchUndoLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            byte[] byArray = ProtostuffIOUtil.toByteArray((Object)branchUndoLog, this.schema, (LinkedBuffer)buffer);
            return byArray;
        }
        finally {
            buffer.clear();
        }
    }

    @Override
    public BranchUndoLog decode(byte[] bytes) {
        if (bytes.length == 0) {
            return new BranchUndoLog();
        }
        BranchUndoLog fooParsed = (BranchUndoLog)this.schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)fooParsed, this.schema);
        return fooParsed;
    }

    public static class DateDelegate
    implements Delegate<java.util.Date> {
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FIXED64;
        }

        public Class<?> typeClass() {
            return java.util.Date.class;
        }

        public java.util.Date readFrom(Input input) throws IOException {
            return new java.util.Date(input.readFixed64());
        }

        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFixed64(number, input.readFixed64(), repeated);
        }

        public void writeTo(Output output, int number, java.util.Date value, boolean repeated) throws IOException {
            output.writeFixed64(number, value.getTime(), repeated);
        }
    }

    public static class TimeDelegate
    implements Delegate<Time> {
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FIXED64;
        }

        public Class<?> typeClass() {
            return Time.class;
        }

        public Time readFrom(Input input) throws IOException {
            return new Time(input.readFixed64());
        }

        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFixed64(number, input.readFixed64(), repeated);
        }

        public void writeTo(Output output, int number, Time value, boolean repeated) throws IOException {
            output.writeFixed64(number, value.getTime(), repeated);
        }
    }

    public static class SqlDateDelegate
    implements Delegate<Date> {
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FIXED64;
        }

        public Class<?> typeClass() {
            return Date.class;
        }

        public Date readFrom(Input input) throws IOException {
            return new Date(input.readFixed64());
        }

        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFixed64(number, input.readFixed64(), repeated);
        }

        public void writeTo(Output output, int number, Date value, boolean repeated) throws IOException {
            output.writeFixed64(number, value.getTime(), repeated);
        }
    }

    public static class TimestampDelegate
    implements Delegate<Timestamp> {
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.BYTES;
        }

        public Class<?> typeClass() {
            return Timestamp.class;
        }

        public Timestamp readFrom(Input input) throws IOException {
            ByteBuffer buffer = input.readByteBuffer();
            long time = buffer.getLong();
            int nanos = buffer.getInt();
            BufferUtils.flip(buffer);
            Timestamp timestamp = new Timestamp(time);
            timestamp.setNanos(nanos);
            return timestamp;
        }

        public void writeTo(Output output, int number, Timestamp value, boolean repeated) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(12);
            buffer.putLong(value.getTime());
            buffer.putInt(value.getNanos());
            BufferUtils.flip(buffer);
            output.writeBytes(number, buffer, repeated);
        }

        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeBytes(number, input.readByteBuffer(), repeated);
        }
    }
}

