/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.parser;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import org.apache.seata.common.executor.Initialize;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.rm.datasource.undo.BranchUndoLog;
import org.apache.seata.rm.datasource.undo.UndoLogParser;

@LoadLevel(name="fastjson2")
public class Fastjson2UndoLogParser
implements UndoLogParser,
Initialize {
    public static final String NAME = "fastjson2";
    private JSONReader.Feature[] jsonReaderFeature;
    private JSONWriter.Feature[] jsonWriterFeature;

    @Override
    public void init() {
        this.jsonReaderFeature = new JSONReader.Feature[]{JSONReader.Feature.UseDefaultConstructorAsPossible, JSONReader.Feature.FieldBased, JSONReader.Feature.IgnoreAutoTypeNotMatch, JSONReader.Feature.UseNativeObject, JSONReader.Feature.SupportAutoType};
        this.jsonWriterFeature = new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName, JSONWriter.Feature.FieldBased, JSONWriter.Feature.ReferenceDetection, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.NotWriteDefaultValue, JSONWriter.Feature.NotWriteHashMapArrayListClassName, JSONWriter.Feature.WriteNameAsSymbol};
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        return this.encode(new BranchUndoLog());
    }

    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        return JSONB.toBytes((Object)branchUndoLog, (JSONWriter.Feature[])this.jsonWriterFeature);
    }

    @Override
    public BranchUndoLog decode(byte[] bytes) {
        return (BranchUndoLog)JSONB.parseObject((byte[])bytes, BranchUndoLog.class, (JSONReader.Feature[])this.jsonReaderFeature);
    }
}

