/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec.mysql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.protocol.Version;
import org.apache.seata.rm.datasource.ConnectionProxy;
import org.apache.seata.rm.datasource.SqlGenerateUtils;
import org.apache.seata.rm.datasource.StatementProxy;
import org.apache.seata.rm.datasource.exec.StatementCallback;
import org.apache.seata.rm.datasource.exec.UpdateExecutor;
import org.apache.seata.rm.datasource.sql.struct.Field;
import org.apache.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.rm.datasource.undo.SQLUndoLog;
import org.apache.seata.sqlparser.JoinRecognizer;
import org.apache.seata.sqlparser.ParametersHolder;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.SQLType;
import org.apache.seata.sqlparser.SQLUpdateRecognizer;
import org.apache.seata.sqlparser.struct.TableMeta;
import org.apache.seata.sqlparser.util.ColumnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLUpdateJoinExecutor<T, S extends Statement>
extends UpdateExecutor<T, S> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DOT = ".";
    private final Map<String, TableRecords> beforeImagesMap = new LinkedHashMap<String, TableRecords>(4);
    private final Map<String, TableRecords> afterImagesMap = new LinkedHashMap<String, TableRecords>(4);
    protected boolean isLowerSupportGroupByPksVersion = Version.convertVersionNotThrowException(this.getDbVersion()) < Version.convertVersionNotThrowException("5.7.5");
    private String sqlMode = "";

    public MySQLUpdateJoinExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        String tableNames = recognizer.getTableName();
        String[] tableItems = tableNames.split("#");
        String joinTable = tableItems[0];
        boolean itemTableIndex = true;
        String suffixCommonCondition = this.buildBeforeImageSQLCommonConditionSuffix(paramAppenderList);
        for (int i = 1; i < tableItems.length; ++i) {
            List<String> itemTableUpdateColumns = this.getItemUpdateColumns(this.getTableMeta(tableItems[i]), recognizer.getUpdateColumns());
            if (CollectionUtils.isEmpty(itemTableUpdateColumns)) continue;
            String selectSQL = this.buildBeforeImageSQL(joinTable, tableItems[i], suffixCommonCondition, itemTableUpdateColumns);
            TableRecords tableRecords = this.buildTableRecords(this.getTableMeta(tableItems[i]), selectSQL, paramAppenderList);
            if (!CollectionUtils.isNotEmpty(tableRecords.getRows())) continue;
            this.beforeImagesMap.put(tableItems[i], tableRecords);
        }
        return null;
    }

    private String buildBeforeImageSQLCommonConditionSuffix(ArrayList<List<Object>> paramAppenderList) {
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        StringBuilder suffix = new StringBuilder();
        this.buildJoinCondition(recognizer, paramAppenderList);
        String whereCondition = this.buildWhereCondition(recognizer, paramAppenderList);
        String orderByCondition = this.buildOrderCondition(recognizer, paramAppenderList);
        String limitCondition = this.buildLimitCondition(recognizer, paramAppenderList);
        if (StringUtils.isNotBlank(whereCondition)) {
            suffix.append(" WHERE ").append(whereCondition);
        }
        if (StringUtils.isNotBlank(orderByCondition)) {
            suffix.append(" ").append(orderByCondition);
        }
        if (StringUtils.isNotBlank(limitCondition)) {
            suffix.append(" ").append(limitCondition);
        }
        return suffix.toString();
    }

    private void buildJoinCondition(SQLUpdateRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        if (this.statementProxy instanceof ParametersHolder) {
            ((JoinRecognizer)((Object)recognizer)).getJoinCondition((ParametersHolder)((Object)this.statementProxy), paramAppenderList);
        }
    }

    private String buildBeforeImageSQL(String joinTable, String itemTable, String suffixCondition, List<String> itemTableUpdateColumns) {
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        TableMeta itemTableMeta = this.getTableMeta(itemTable);
        StringBuilder prefix = new StringBuilder("SELECT ");
        StringBuilder suffix = new StringBuilder(" FROM ").append(joinTable);
        suffix.append(suffixCondition);
        suffix.append(" GROUP BY ");
        List<String> pkColumnNames = this.getColumnNamesWithTablePrefixList(itemTable, recognizer.getTableAlias(itemTable), itemTableMeta.getPrimaryKeyOnlyName());
        List<String> needUpdateColumns = this.getNeedColumns(itemTable, recognizer.getTableAlias(itemTable), itemTableUpdateColumns);
        suffix.append(this.buildGroupBy(pkColumnNames, needUpdateColumns));
        suffix.append(" FOR UPDATE");
        StringJoiner selectSQLJoin = new StringJoiner(", ", prefix.toString(), suffix.toString());
        needUpdateColumns.forEach(selectSQLJoin::add);
        return selectSQLJoin.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        String tableNames = recognizer.getTableName();
        String[] tableItems = tableNames.split("#");
        String joinTable = tableItems[0];
        boolean itemTableIndex = true;
        ArrayList<List<Object>> joinConditionParams = new ArrayList<List<Object>>();
        this.buildJoinCondition(recognizer, joinConditionParams);
        for (int i = 1; i < tableItems.length; ++i) {
            TableRecords tableBeforeImage = this.beforeImagesMap.get(tableItems[i]);
            if (tableBeforeImage == null || CollectionUtils.isEmpty(tableBeforeImage.getRows())) continue;
            String selectSQL = this.buildAfterImageSQL(joinTable, tableItems[i], tableBeforeImage);
            PreparedStatement pst = null;
            ResultSet rs = null;
            try {
                pst = this.statementProxy.getConnection().prepareStatement(selectSQL);
                this.setAfterImageSQLPlaceHolderParams(joinConditionParams, tableBeforeImage.pkRows(), this.getTableMeta(tableItems[i]).getPrimaryKeyOnlyName(), pst);
                rs = pst.executeQuery();
                TableRecords afterImage = TableRecords.buildRecords(this.getTableMeta(tableItems[i]), rs);
                this.afterImagesMap.put(tableItems[i], afterImage);
            }
            catch (Throwable throwable) {
                IOUtil.close(rs, pst);
                throw throwable;
            }
            IOUtil.close(rs, pst);
        }
        return null;
    }

    private void setAfterImageSQLPlaceHolderParams(ArrayList<List<Object>> joinConditionParams, List<Map<String, Field>> pkRowsList, List<String> pkColumnNameList, PreparedStatement pst) throws SQLException {
        int i;
        int paramIndex = 1;
        if (CollectionUtils.isNotEmpty(joinConditionParams)) {
            int ts = joinConditionParams.size();
            for (i = 0; i < ts; ++i) {
                List<Object> paramAppender = joinConditionParams.get(i);
                int ds = paramAppender.size();
                for (int j = 0; j < ds; ++j) {
                    pst.setObject(paramIndex, paramAppender.get(j));
                    ++paramIndex;
                }
            }
        }
        for (i = 0; i < pkRowsList.size(); ++i) {
            Map<String, Field> rowData = pkRowsList.get(i);
            for (String columnName : pkColumnNameList) {
                Field pkField = rowData.get(columnName);
                pst.setObject(paramIndex, pkField.getValue(), pkField.getType());
                ++paramIndex;
            }
        }
    }

    private String buildAfterImageSQL(String joinTable, String itemTable, TableRecords beforeImage) throws SQLException {
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        TableMeta itemTableMeta = this.getTableMeta(itemTable);
        List<String> pkColumns = this.getColumnNamesWithTablePrefixList(itemTable, recognizer.getTableAlias(itemTable), itemTableMeta.getPrimaryKeyOnlyName());
        List<String> itemTableUpdateColumns = this.getItemUpdateColumns(itemTableMeta, recognizer.getUpdateColumns());
        List<String> needUpdateColumns = this.getNeedColumns(itemTable, recognizer.getTableAlias(itemTable), itemTableUpdateColumns);
        StringJoiner selectSQLJoiner = new StringJoiner(", ", "SELECT ", " FROM " + joinTable + " WHERE ");
        needUpdateColumns.forEach(selectSQLJoiner::add);
        return SqlGenerateUtils.buildSQLByPKs(selectSQLJoiner.toString(), " GROUP BY " + this.buildGroupBy(pkColumns, needUpdateColumns), pkColumns, beforeImage.pkRows().size(), this.getDbType());
    }

    private List<String> getItemUpdateColumns(TableMeta itemTableMeta, List<String> updateColumns) {
        ArrayList<String> itemUpdateColumns = new ArrayList<String>();
        Set<String> itemTableAllColumns = itemTableMeta.getAllColumns().keySet();
        String itemTableName = itemTableMeta.getTableName();
        String itemTableNameAlias = ((SQLUpdateRecognizer)this.sqlRecognizer).getTableAlias(itemTableName);
        for (String updateColumn : updateColumns) {
            if (updateColumn.contains(DOT)) {
                String[] specificTableColumn = updateColumn.split("\\.");
                String tableNamePrefix = specificTableColumn[0];
                String column = specificTableColumn[1];
                if (!tableNamePrefix.equals(itemTableName) && !tableNamePrefix.equals(itemTableNameAlias) || !itemTableAllColumns.contains(column)) continue;
                itemUpdateColumns.add(updateColumn);
                continue;
            }
            if (!itemTableAllColumns.contains(updateColumn)) continue;
            itemUpdateColumns.add(updateColumn);
        }
        return itemUpdateColumns;
    }

    @Override
    protected void prepareUndoLog(TableRecords beforeImage, TableRecords afterImage) throws SQLException {
        if (CollectionUtils.isEmpty(this.beforeImagesMap) && CollectionUtils.isEmpty(this.afterImagesMap)) {
            return;
        }
        if (CollectionUtils.isEmpty(this.beforeImagesMap) || CollectionUtils.isEmpty(this.afterImagesMap)) {
            throw new IllegalStateException("images can not be null");
        }
        for (Map.Entry<String, TableRecords> entry : this.beforeImagesMap.entrySet()) {
            String tableName = entry.getKey();
            TableRecords tableBeforeImage = entry.getValue();
            TableRecords tableAfterImage = this.afterImagesMap.get(tableName);
            if (tableBeforeImage.getRows().size() != tableAfterImage.getRows().size()) {
                throw new ShouldNeverHappenException("Before image size is not equaled to after image size, probably because you updated the primary keys.");
            }
            super.prepareUndoLog(tableBeforeImage, tableAfterImage);
        }
    }

    @Override
    protected TableMeta getTableMeta(String tableName) {
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        return TableMetaCacheFactory.getTableMetaCache(connectionProxy.getDbType()).getTableMeta(connectionProxy.getTargetConnection(), tableName, connectionProxy.getDataSourceProxy().getResourceId());
    }

    @Override
    protected SQLUndoLog buildUndoItem(TableRecords beforeImage, TableRecords afterImage) {
        SQLType sqlType = this.sqlRecognizer.getSQLType();
        String tableName = beforeImage.getTableName();
        SQLUndoLog sqlUndoLog = new SQLUndoLog();
        sqlUndoLog.setSqlType(sqlType);
        sqlUndoLog.setTableName(tableName);
        sqlUndoLog.setBeforeImage(beforeImage);
        sqlUndoLog.setAfterImage(afterImage);
        return sqlUndoLog;
    }

    private String buildGroupBy(List<String> pkColumns, List<String> allSelectColumns) {
        boolean groupByPks;
        block31: {
            groupByPks = true;
            try {
                if (!this.isLowerSupportGroupByPksVersion) break block31;
                if (StringUtils.isEmpty(this.sqlMode)) {
                    try (PreparedStatement preparedStatement = this.statementProxy.getConnection().prepareStatement("SELECT @@SQL_MODE");
                         ResultSet resultSet = preparedStatement.executeQuery();){
                        if (resultSet.next()) {
                            this.sqlMode = resultSet.getString("@@SQL_MODE");
                        }
                    }
                }
                if (this.sqlMode.contains("ONLY_FULL_GROUP_BY")) {
                    groupByPks = false;
                }
            }
            catch (Exception e) {
                groupByPks = false;
                this.logger.warn("determine group by pks or all columns error:{}", (Object)e.getMessage());
            }
        }
        List<String> groupByColumns = groupByPks ? pkColumns : allSelectColumns;
        StringBuilder groupByStr = new StringBuilder();
        for (int i = 0; i < groupByColumns.size(); ++i) {
            if (i > 0) {
                groupByStr.append(",");
            }
            groupByStr.append(ColumnUtils.addEscape(groupByColumns.get(i), this.getDbType()));
        }
        return groupByStr.toString();
    }

    private String getDbVersion() {
        return this.statementProxy.getConnectionProxy().getDataSourceProxy().getKernelVersion();
    }
}

