/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.util;

import java.util.Objects;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.integration.tx.api.json.JsonParserFactory;

public class JsonUtil {
    private static final String CONFIG_JSON_PARSER_NAME = ConfigurationFactory.getInstance().getConfig("tcc.contextJsonParserType", "fastjson");

    public static String toJSONString(Object object) {
        return JsonParserFactory.getInstance(CONFIG_JSON_PARSER_NAME).toJSONString(object);
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (Objects.isNull(text) || Objects.isNull(clazz)) {
            return null;
        }
        String jsonParseName = text.startsWith("{\"@class\":") ? "jackson" : CONFIG_JSON_PARSER_NAME;
        return JsonParserFactory.getInstance(jsonParseName).parseObject(text, clazz);
    }
}

