/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.store.db;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.executor.Initialize;
import org.apache.seata.common.util.ConfigTools;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.constants.DBType;
import org.apache.seata.core.store.db.DataSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceProvider
implements DataSourceProvider,
Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataSourceProvider.class);
    private DataSource dataSource;
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final String MYSQL_DRIVER_CLASS_NAME = "com.mysql.jdbc.Driver";
    private static final String MYSQL8_DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String MYSQL_DRIVER_FILE_PREFIX = "mysql-connector-j";
    private static final Map<String, ClassLoader> DRIVER_LOADERS = AbstractDataSourceProvider.createMysqlDriverClassLoaders();
    private static final long DEFAULT_DB_MAX_WAIT = 5000L;

    @Override
    public void init() {
        this.dataSource = this.generate();
    }

    @Override
    public DataSource provide() {
        return this.dataSource;
    }

    public DataSource generate() {
        this.validate();
        return this.doGenerate();
    }

    public void validate() {
        String driverClassName = this.getDriverClassName();
        ClassLoader loader = this.getDriverClassLoader();
        if (null == loader) {
            throw new StoreException("class loader set error, you should not use the Bootstrap classloader");
        }
        try {
            loader.loadClass(driverClassName);
        }
        catch (ClassNotFoundException exx) {
            String folderPath = System.getProperty("loader.path");
            if (folderPath == null) {
                folderPath = System.getProperty("java.class.path");
            }
            String driverClassPath = Stream.of(folderPath.split(File.pathSeparator)).map(File::new).filter(File::exists).map(file -> file.isFile() ? file.getParentFile() : file).filter(Objects::nonNull).filter(File::isDirectory).map(file -> MYSQL8_DRIVER_CLASS_NAME.equals(driverClassName) || MYSQL_DRIVER_CLASS_NAME.equals(driverClassName) ? new File((File)file, "jdbc") : file).filter(File::exists).filter(File::isDirectory).distinct().findAny().map(File::getAbsolutePath).orElseThrow(() -> new ShouldNeverHappenException("cannot find jdbc folder"));
            throw new StoreException(String.format("The driver {%s} cannot be found in the path %s. Please ensure that the appropriate database driver dependencies are included in the classpath.", driverClassName, driverClassPath));
        }
    }

    public abstract DataSource doGenerate();

    protected DBType getDBType() {
        return DBType.valueof(CONFIG.getConfig("store.db.dbType"));
    }

    protected String getDriverClassName() {
        String driverClassName = CONFIG.getConfig("store.db.driverClassName");
        if (StringUtils.isBlank(driverClassName)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.driverClassName"));
        }
        return driverClassName;
    }

    protected Long getMaxWait() {
        return CONFIG.getLong("store.db.maxWait", 5000L);
    }

    protected ClassLoader getDriverClassLoader() {
        return DRIVER_LOADERS.getOrDefault(this.getDriverClassName(), this.getClass().getClassLoader());
    }

    private static Map<String, ClassLoader> createMysqlDriverClassLoaders() {
        HashMap<String, ClassLoader> loaders = new HashMap<String, ClassLoader>();
        String cp = System.getProperty("loader.path");
        if (cp == null) {
            cp = System.getProperty("java.class.path");
        }
        if (cp == null || cp.isEmpty()) {
            return loaders;
        }
        Stream.of(cp.split(File.pathSeparator)).map(File::new).filter(File::exists).map(file -> file.isFile() ? file.getParentFile() : file).filter(Objects::nonNull).filter(File::isDirectory).map(file -> new File((File)file, "jdbc")).filter(File::exists).filter(File::isDirectory).distinct().flatMap(file -> {
            File[] files = file.listFiles((f, name) -> name.startsWith(MYSQL_DRIVER_FILE_PREFIX));
            if (files != null) {
                return Stream.of(files);
            }
            return Stream.of(new File[0]);
        }).forEach(file -> {
            if (loaders.containsKey(MYSQL8_DRIVER_CLASS_NAME) && loaders.containsKey(MYSQL_DRIVER_CLASS_NAME)) {
                return;
            }
            try {
                URL url = file.toURI().toURL();
                URLClassLoader loader = new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
                try {
                    loader.loadClass(MYSQL8_DRIVER_CLASS_NAME);
                    loaders.putIfAbsent(MYSQL8_DRIVER_CLASS_NAME, loader);
                }
                catch (ClassNotFoundException e) {
                    loaders.putIfAbsent(MYSQL_DRIVER_CLASS_NAME, loader);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        });
        return loaders;
    }

    protected String getUrl() {
        String url = CONFIG.getConfig("store.db.url");
        if (StringUtils.isBlank(url)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.url"));
        }
        return url;
    }

    protected String getUser() {
        String user = CONFIG.getConfig("store.db.user");
        if (StringUtils.isBlank(user)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.user"));
        }
        return user;
    }

    protected String getPassword() {
        String password = CONFIG.getConfig("store.db.password");
        String publicKey = this.getPublicKey();
        if (StringUtils.isNotBlank(publicKey)) {
            try {
                password = ConfigTools.publicDecrypt(password, publicKey);
            }
            catch (Exception e) {
                LOGGER.error("decryption failed,please confirm whether the ciphertext and secret key are correct! error msg: {}", (Object)e.getMessage());
            }
        }
        return password;
    }

    protected int getMinConn() {
        int minConn = CONFIG.getInt("store.db.minConn", 10);
        return minConn < 0 ? 10 : minConn;
    }

    protected int getMaxConn() {
        int maxConn = CONFIG.getInt("store.db.maxConn", 100);
        return maxConn < 0 ? 100 : maxConn;
    }

    protected String getValidationQuery(DBType dbType) {
        if (DBType.ORACLE.equals((Object)dbType)) {
            return "select sysdate from dual";
        }
        return "select 1";
    }

    protected String getPublicKey() {
        return CONFIG.getConfig("store.publicKey");
    }
}

