/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamFrame;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import org.apache.seata.common.rpc.http.HttpContext;
import org.apache.seata.core.rpc.netty.http.BaseHttpChannelHandler;
import org.apache.seata.core.rpc.netty.http.ControllerManager;
import org.apache.seata.core.rpc.netty.http.HttpInvocation;
import org.apache.seata.core.rpc.netty.http.ParameterParser;
import org.apache.seata.core.rpc.netty.http.SimpleHttp2Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2HttpHandler
extends BaseHttpChannelHandler<Http2StreamFrame> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2HttpHandler.class);
    private Http2Headers http2Headers;
    private ByteBuf bodyBuffer;
    private boolean headersEndStream = false;

    protected void channelRead0(ChannelHandlerContext ctx, Http2StreamFrame msg) throws Exception {
        if (this.bodyBuffer == null) {
            this.bodyBuffer = ctx.alloc().buffer();
        }
        try {
            if (msg instanceof Http2HeadersFrame) {
                Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
                this.http2Headers = headersFrame.headers();
                this.headersEndStream = headersFrame.isEndStream();
                if (this.headersEndStream) {
                    this.handleRequest(ctx);
                }
            } else if (msg instanceof Http2DataFrame) {
                Http2DataFrame dataFrame = (Http2DataFrame)msg;
                this.bodyBuffer.writeBytes(dataFrame.content());
                if (dataFrame.isEndStream()) {
                    this.handleRequest(ctx);
                }
            }
        }
        catch (Exception e) {
            if (this.bodyBuffer != null) {
                this.bodyBuffer.release();
                this.bodyBuffer = null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(ChannelHandlerContext ctx) {
        try {
            if (this.http2Headers == null || this.http2Headers.method() == null || this.http2Headers.path() == null) {
                this.sendErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            HttpMethod method = HttpMethod.valueOf((String)this.http2Headers.method().toString());
            String path = this.http2Headers.path().toString();
            String body = this.bodyBuffer != null ? this.bodyBuffer.toString(StandardCharsets.UTF_8) : "";
            SimpleHttp2Request request = new SimpleHttp2Request(method, path, this.http2Headers, body);
            boolean keepAlive = true;
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.getPath());
            String requestPath = queryStringDecoder.path();
            HttpInvocation httpInvocation = ControllerManager.getHttpInvocation(requestPath);
            if (httpInvocation == null) {
                this.sendErrorResponse(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            HttpContext<SimpleHttp2Request> httpContext = new HttpContext<SimpleHttp2Request>(request, ctx, keepAlive, "HTTP/2.0");
            ObjectNode requestDataNode = OBJECT_MAPPER.createObjectNode();
            requestDataNode.set("param", (JsonNode)ParameterParser.convertParamMap(queryStringDecoder.parameters()));
            if (request.getMethod() == HttpMethod.POST && request.getBody() != null && !request.getBody().isEmpty()) {
                try {
                    ObjectNode bodyDataNode = (ObjectNode)OBJECT_MAPPER.readTree(request.getBody());
                    requestDataNode.set("body", (JsonNode)bodyDataNode);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to parse http2 body as json: {}", (Object)e.getMessage());
                }
            }
            Object httpController = httpInvocation.getController();
            Method handleMethod = httpInvocation.getMethod();
            Object[] args = ParameterParser.getArgValues(httpInvocation.getParamMetaData(), handleMethod, requestDataNode, httpContext);
            this.handle(httpController, handleMethod, args, ctx, httpContext);
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while processing HTTP2 request: {}", (Object)e.getMessage(), (Object)e);
            this.sendErrorResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        finally {
            if (this.bodyBuffer != null) {
                this.bodyBuffer.release();
                this.bodyBuffer = null;
            }
            this.http2Headers = null;
            this.headersEndStream = false;
        }
    }

    private void handle(Object httpController, Method handleMethod, Object[] args, ChannelHandlerContext ctx, HttpContext<SimpleHttp2Request> httpContext) {
        HTTP_HANDLER_THREADS.execute(() -> {
            try {
                Object result = handleMethod.invoke(httpController, args);
                if (!httpContext.isAsync()) {
                    this.sendResponse(ctx, result);
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Illegal argument exception: {}", (Object)e.getMessage(), (Object)e);
                this.sendErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST);
            }
            catch (Exception e) {
                LOGGER.error("Exception occurred while processing HTTP2 request: {}", (Object)e.getMessage(), (Object)e);
                this.sendErrorResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        });
    }

    private void sendResponse(ChannelHandlerContext ctx, Object result) throws Exception {
        byte[] body = result != null ? OBJECT_MAPPER.writeValueAsBytes(result) : new byte[]{};
        Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText());
        headers.set((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=UTF-8");
        headers.set((Object)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(body.length));
        ctx.write((Object)new DefaultHttp2HeadersFrame(headers));
        if (body.length > 0) {
            ByteBuf content = Unpooled.wrappedBuffer((byte[])body);
            ctx.write((Object)new DefaultHttp2DataFrame(content, true));
        } else {
            ctx.write((Object)new DefaultHttp2DataFrame(Unpooled.EMPTY_BUFFER, true));
        }
        ctx.flush();
    }

    private void sendErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status) {
        Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)status.codeAsText());
        ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame(headers, true));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof IOException) {
            LOGGER.trace("Client connection closed: {}", (Object)cause.getMessage());
        } else {
            LOGGER.error("Exception caught in Http2HttpHandler: ", cause);
        }
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            if (this.bodyBuffer != null) {
                this.bodyBuffer.release();
                this.bodyBuffer = null;
            }
        }
        finally {
            super.channelInactive(ctx);
        }
    }
}

