/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc;

import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.List;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.protocol.MessageTypeAware;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.protocol.Version;

public class MsgVersionHelper {
    private static final List<Short> SKIP_MSG_CODE_V0 = Arrays.asList((short)111);

    public static boolean versionNotSupport(Channel channel, RpcMessage rpcMessage) {
        if (rpcMessage == null || rpcMessage.getBody() == null || channel == null) {
            return false;
        }
        Object msg = rpcMessage.getBody();
        String version = Version.getChannelVersion(channel);
        if (StringUtils.isBlank(version) || msg == null) {
            return false;
        }
        boolean isV0 = Version.isV0(version);
        if (!isV0 || !(msg instanceof MessageTypeAware)) {
            return false;
        }
        short typeCode = ((MessageTypeAware)msg).getTypeCode();
        return SKIP_MSG_CODE_V0.contains(typeCode);
    }
}

