/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.pojo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.MaxRowsDataSet;
import org.apache.metamodel.pojo.PojoDataSet;
import org.apache.metamodel.pojo.PojoUpdateCallback;
import org.apache.metamodel.pojo.TableDataProvider;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;

public class PojoDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_SCHEMA_NAME = "Schema";
    private final Map<String, TableDataProvider<?>> _tables;
    private final String _schemaName;

    public PojoDataContext() {
        this(new ArrayList());
    }

    public PojoDataContext(List<TableDataProvider<?>> tables) {
        this(DEFAULT_SCHEMA_NAME, tables);
    }

    public PojoDataContext(String schemaName, TableDataProvider ... tableProviders) {
        this(schemaName, Arrays.asList(tableProviders));
    }

    public PojoDataContext(String schemaName, List<TableDataProvider<?>> tables) {
        super(true);
        if (schemaName == null) {
            throw new IllegalArgumentException("Schema name cannot be null");
        }
        this._schemaName = schemaName;
        this._tables = new TreeMap();
        for (TableDataProvider<?> pojoTable : tables) {
            this.addTableDataProvider(pojoTable);
        }
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        TableDataProvider<?> pojoTable = this._tables.get(table.getName());
        if (pojoTable == null) {
            throw new IllegalArgumentException("No such POJO table: " + table.getName());
        }
        List<SelectItem> selectItems = columns.stream().map(SelectItem::new).collect(Collectors.toList());
        MaxRowsDataSet dataSet = new PojoDataSet(pojoTable, selectItems);
        if (maxRows > 0) {
            dataSet = new MaxRowsDataSet(dataSet, maxRows);
        }
        return dataSet;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this.getMainSchemaName());
        for (TableDataProvider<?> pojoTable : this._tables.values()) {
            SimpleTableDef tableDef = pojoTable.getTableDef();
            MutableTable table = tableDef.toTable();
            table.setSchema((Schema)schema);
            schema.addTable((Table)table);
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateSummary executeUpdate(UpdateScript update) {
        PojoUpdateCallback updateCallback = new PojoUpdateCallback(this);
        PojoDataContext pojoDataContext = this;
        synchronized (pojoDataContext) {
            update.run((UpdateCallback)updateCallback);
        }
        return updateCallback.getUpdateSummary();
    }

    protected void addTableDataProvider(TableDataProvider<?> tableDataProvider) {
        this._tables.put(tableDataProvider.getName(), tableDataProvider);
    }

    public void insert(String tableName, Map<String, Object> recordData) {
        TableDataProvider<?> table = this._tables.get(tableName);
        if (table == null) {
            throw new IllegalArgumentException("No table data provider for table: " + tableName);
        }
        table.insert(recordData);
    }
}

