/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.DefaultQueryRewriter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;

public class OracleQueryRewriter
extends DefaultQueryRewriter {
    public static final int FIRST_FETCH_SUPPORTING_VERSION = 12;

    public OracleQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public ColumnType getColumnType(int jdbcType, String nativeType, Integer columnSize) {
        if (nativeType.contains("TIMESTAMP")) {
            return ColumnType.TIMESTAMP;
        }
        return super.getColumnType(jdbcType, nativeType, columnSize);
    }

    @Override
    public void setStatementParameter(PreparedStatement st, int valueIndex, Column column, Object value) throws SQLException {
        if (column.getType() == ColumnType.CLOB) {
            if (value == null) {
                st.setObject(valueIndex, null);
            } else {
                System.out.println("clob string");
                CLOB clob = CLOB.createTemporary((Connection)((Connection)st.getConnection().unwrap(OracleConnection.class)), (boolean)false, (int)10);
                clob.setString(1L, value.toString());
                st.setClob(valueIndex, (Clob)clob);
            }
            return;
        }
        super.setStatementParameter(st, valueIndex, column, value);
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.NUMBER || columnType == ColumnType.NUMERIC || columnType == ColumnType.DECIMAL) {
            super.rewriteColumnTypeInternal("NUMBER", columnSize);
        }
        if (columnType == ColumnType.BOOLEAN || columnType == ColumnType.BIT) {
            return "NUMBER(3)";
        }
        if (columnType == ColumnType.DOUBLE) {
            return "BINARY_DOUBLE";
        }
        if (columnType == ColumnType.FLOAT) {
            return "BINARY_FLOAT";
        }
        if (columnType == ColumnType.BINARY || columnType == ColumnType.VARBINARY) {
            return "RAW";
        }
        if (columnType == ColumnType.TINYINT) {
            return "NUMBER(3)";
        }
        if (columnType == ColumnType.SMALLINT) {
            return "NUMBER(5)";
        }
        if (columnType == ColumnType.INTEGER) {
            return "NUMBER(10)";
        }
        if (columnType == ColumnType.BIGINT) {
            return "NUMBER(19)";
        }
        if (columnType == ColumnType.TIME) {
            super.rewriteColumnType(ColumnType.DATE, columnSize);
        }
        return super.rewriteColumnType(columnType, columnSize);
    }

    @Override
    public String rewriteFilterItem(FilterItem item) {
        if (item.getOperand() instanceof String && item.getOperand().equals("")) {
            return super.rewriteFilterItem(new FilterItem(item.getSelectItem(), item.getOperator(), null));
        }
        return super.rewriteFilterItem(item);
    }
}

