/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.LimitOffsetQueryRewriter;
import org.apache.metamodel.schema.ColumnType;

public class MysqlQueryRewriter
extends LimitOffsetQueryRewriter {
    public MysqlQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public String escapeQuotes(String filterItemOperand) {
        return filterItemOperand.replaceAll("\\'", "\\\\'");
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.NUMERIC) {
            return super.rewriteColumnType(ColumnType.DECIMAL, columnSize);
        }
        if (columnType == ColumnType.NCLOB || columnType == ColumnType.CLOB) {
            return "TEXT";
        }
        if (columnType.isLiteral() && columnSize == null && (columnType == ColumnType.STRING || columnType == ColumnType.VARCHAR || columnType == ColumnType.NVARCHAR)) {
            return "TEXT";
        }
        return super.rewriteColumnType(columnType, columnSize);
    }
}

