/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.stream;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.booter.Constants;
import org.apache.maven.surefire.api.fork.ForkNodeArguments;
import org.apache.maven.surefire.api.stream.MalformedChannelException;
import org.apache.maven.surefire.shared.lang3.StringUtils;

public abstract class AbstractStreamDecoder<M, MT extends Enum<MT>, ST extends Enum<ST>>
implements AutoCloseable {
    public static final int BUFFER_SIZE = 1024;
    private static final String PRINTABLE_JVM_NATIVE_STREAM = "Listening for transport dt_socket at address:";
    private static final String[] JVM_ERROR_PATTERNS = new String[]{"could not create the java virtual machine", "error occurred during initialization", "error:", "could not reserve enough space", "could not allocate", "unable to allocate", "java.lang.module.findexception"};
    private static final byte[] DEFAULT_STREAM_ENCODING_BYTES = Constants.DEFAULT_STREAM_ENCODING.name().getBytes(StandardCharsets.US_ASCII);
    private static final int NO_POSITION = -1;
    private static final int DELIMITER_LENGTH = 1;
    private static final int BYTE_LENGTH = 1;
    private static final int INT_LENGTH = 4;
    private static final int LONG_LENGTH = 8;
    private final ReadableByteChannel channel;
    private final ForkNodeArguments arguments;
    private final Map<Segment, MT> messageTypes;
    private final ConsoleLogger logger;

    protected AbstractStreamDecoder(@Nonnull ReadableByteChannel channel, @Nonnull ForkNodeArguments arguments, @Nonnull Map<Segment, MT> messageTypes) {
        this.channel = channel;
        this.arguments = arguments;
        this.messageTypes = messageTypes;
        this.logger = arguments.getConsoleLogger();
    }

    public abstract M decode(@Nonnull Memento var1) throws MalformedChannelException, IOException;

    @Nonnull
    protected abstract byte[] getEncodedMagicNumber();

    @Nonnull
    protected abstract ST[] nextSegmentType(@Nonnull MT var1);

    @Nonnull
    protected abstract M toMessage(@Nonnull MT var1, @Nonnull Memento var2) throws MalformedFrameException;

    @Nonnull
    protected final ForkNodeArguments getArguments() {
        return this.arguments;
    }

    protected void debugStream(byte[] array, int position, int remaining) {
    }

    protected MT readMessageType(@Nonnull Memento memento) throws IOException, MalformedFrameException {
        byte[] header = this.getEncodedMagicNumber();
        int readCount = 1 + header.length + 1 + 1 + 1;
        this.read(memento, readCount);
        this.checkHeader(memento);
        return (MT)((Enum)this.messageTypes.get(this.readSegment(memento)));
    }

    @Nonnull
    protected Segment readSegment(@Nonnull Memento memento) throws IOException, MalformedFrameException {
        int readCount = this.readByte(memento) & 0xFF;
        this.read(memento, readCount + 1);
        ByteBuffer bb = memento.getByteBuffer();
        Segment segment = new Segment(bb.array(), bb.arrayOffset() + bb.position(), readCount);
        ((Buffer)bb).position(bb.position() + readCount);
        this.checkDelimiter(memento);
        return segment;
    }

    @Nonnull
    protected Charset readCharset(@Nonnull Memento memento) throws IOException, MalformedFrameException {
        int length = this.readByte(memento) & 0xFF;
        this.read(memento, length + 1);
        ByteBuffer bb = memento.getByteBuffer();
        byte[] array = bb.array();
        int offset = bb.arrayOffset() + bb.position();
        ((Buffer)bb).position(bb.position() + length);
        boolean isDefaultEncoding = false;
        if (length == DEFAULT_STREAM_ENCODING_BYTES.length) {
            isDefaultEncoding = true;
            for (int i = 0; i < length; ++i) {
                isDefaultEncoding &= DEFAULT_STREAM_ENCODING_BYTES[i] == array[offset + i];
            }
        }
        try {
            Charset charset = isDefaultEncoding ? Constants.DEFAULT_STREAM_ENCODING : Charset.forName(new String(array, offset, length, StandardCharsets.US_ASCII));
            this.checkDelimiter(memento);
            return charset;
        }
        catch (IllegalArgumentException e) {
            throw new MalformedFrameException(memento.getLine().getPositionByteBuffer(), bb.position());
        }
    }

    protected String readString(@Nonnull Memento memento) throws IOException, MalformedFrameException {
        String string;
        ((Buffer)memento.getCharBuffer()).clear();
        int readCount = this.readInt(memento);
        if (readCount < 0) {
            throw new MalformedFrameException(memento.getLine().getPositionByteBuffer(), memento.getByteBuffer().position());
        }
        this.read(memento, readCount + 1);
        if (readCount == 0) {
            string = "";
        } else if (readCount == 1) {
            this.read(memento, 1);
            byte oneChar = memento.getByteBuffer().get();
            string = oneChar == 0 ? null : String.valueOf((char)oneChar);
        } else {
            string = this.readString(memento, readCount);
        }
        this.read(memento, 1);
        this.checkDelimiter(memento);
        return string;
    }

    protected Integer readInteger(@Nonnull Memento memento) throws IOException, MalformedFrameException {
        boolean isNullObject;
        this.read(memento, 1);
        boolean bl = isNullObject = memento.getByteBuffer().get() == 0;
        if (isNullObject) {
            this.read(memento, 1);
            this.checkDelimiter(memento);
            return null;
        }
        return this.readInt(memento);
    }

    protected byte readByte(@Nonnull Memento memento) throws IOException, MalformedFrameException {
        this.read(memento, 2);
        byte b = memento.getByteBuffer().get();
        this.checkDelimiter(memento);
        return b;
    }

    protected int readInt(@Nonnull Memento memento) throws IOException, MalformedFrameException {
        this.read(memento, 5);
        int i = memento.getByteBuffer().getInt();
        this.checkDelimiter(memento);
        return i;
    }

    protected Long readLong(@Nonnull Memento memento) throws IOException, MalformedFrameException {
        boolean isNullObject;
        this.read(memento, 1);
        boolean bl = isNullObject = memento.getByteBuffer().get() == 0;
        if (isNullObject) {
            this.read(memento, 1);
            this.checkDelimiter(memento);
            return null;
        }
        return this.readLongPrivate(memento);
    }

    protected long readLongPrivate(@Nonnull Memento memento) throws IOException, MalformedFrameException {
        this.read(memento, 9);
        long num = memento.getByteBuffer().getLong();
        this.checkDelimiter(memento);
        return num;
    }

    protected final void checkDelimiter(Memento memento) throws MalformedFrameException {
        ByteBuffer bb = memento.bb;
        if ((0xFF & bb.get()) != 58) {
            throw new MalformedFrameException(memento.getLine().getPositionByteBuffer(), bb.position());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkHeader(Memento memento) throws MalformedFrameException {
        int shift;
        ByteBuffer bb = memento.bb;
        this.checkDelimiter(memento);
        try {
            byte[] header = this.getEncodedMagicNumber();
            byte[] bbArray = bb.array();
            int start = bb.arrayOffset() + bb.position();
            int length = header.length;
            for (shift = 0; shift < length; ++shift) {
                if (bbArray[shift + start] == header[shift]) continue;
                throw new MalformedFrameException(memento.getLine().getPositionByteBuffer(), bb.position() + shift);
            }
        }
        finally {
            ((Buffer)bb).position(bb.position() + shift);
        }
        this.checkDelimiter(memento);
    }

    protected void checkArguments(Memento memento, int expectedDataElements) throws MalformedFrameException {
        if (memento.getData().size() != expectedDataElements) {
            throw new MalformedFrameException(memento.getLine().getPositionByteBuffer(), memento.getByteBuffer().position());
        }
    }

    private String readString(@Nonnull Memento memento, @Nonnegative int totalBytes) throws IOException, MalformedFrameException {
        memento.getDecoder().reset();
        CharBuffer output = memento.getCharBuffer();
        ((Buffer)output).clear();
        ByteBuffer input = memento.getByteBuffer();
        ArrayList<String> strings = new ArrayList<String>();
        int countDecodedBytes = 0;
        boolean endOfInput = false;
        while (!endOfInput) {
            int readInputBytes;
            int bytesToRead = totalBytes - countDecodedBytes;
            this.read(memento, bytesToRead);
            int bytesToDecode = Math.min(input.remaining(), bytesToRead);
            boolean isLastChunk = bytesToDecode == bytesToRead;
            endOfInput = countDecodedBytes + bytesToDecode >= totalBytes;
            do {
                boolean endOfChunk = output.remaining() >= bytesToRead;
                boolean endOfOutput = isLastChunk && endOfChunk;
                readInputBytes = AbstractStreamDecoder.decodeString(memento.getDecoder(), input, output, bytesToDecode, endOfOutput, memento.getLine().getPositionByteBuffer());
                countDecodedBytes += readInputBytes;
            } while (isLastChunk && (bytesToDecode -= readInputBytes) > 0 && output.hasRemaining());
            strings.add(((Buffer)output).flip().toString());
            ((Buffer)output).clear();
        }
        memento.getDecoder().reset();
        ((Buffer)output).clear();
        return AbstractStreamDecoder.toString(strings);
    }

    private static int decodeString(@Nonnull CharsetDecoder decoder, @Nonnull ByteBuffer input, @Nonnull CharBuffer output, @Nonnegative int bytesToDecode, boolean endOfInput, @Nonnegative int errorStreamFrom) throws MalformedFrameException {
        int limit = input.limit();
        ((Buffer)input).limit(input.position() + bytesToDecode);
        CoderResult result = decoder.decode(input, output, endOfInput);
        if (result.isError() || result.isMalformed()) {
            throw new MalformedFrameException(errorStreamFrom, input.position());
        }
        int decodedBytes = bytesToDecode - input.remaining();
        ((Buffer)input).limit(limit);
        return decodedBytes;
    }

    private static String toString(List<String> strings) {
        if (strings.size() == 1) {
            return strings.get(0);
        }
        StringBuilder concatenated = new StringBuilder(strings.size() * 1024);
        for (String s : strings) {
            concatenated.append(s);
        }
        return concatenated.toString();
    }

    private void printCorruptedStream(Memento memento) {
        ByteBuffer bb = memento.getByteBuffer();
        if (bb.hasRemaining()) {
            int bytesToWrite = bb.remaining();
            memento.getLine().write(bb, bb.position(), bytesToWrite);
            ((Buffer)bb).position(bb.position() + bytesToWrite);
        }
    }

    protected final void printRemainingStream(Memento memento) {
        this.printCorruptedStream(memento);
        memento.getLine().printExistingLine();
        memento.getLine().clear();
    }

    @Nonnull
    protected StreamReadStatus read(@Nonnull Memento memento, int recommendedCount) throws IOException {
        ByteBuffer buffer = memento.getByteBuffer();
        if (buffer.remaining() >= recommendedCount && buffer.limit() != 0) {
            return StreamReadStatus.OVERFLOW;
        }
        if (buffer.position() != 0 && recommendedCount > buffer.capacity() - buffer.position()) {
            ((Buffer)buffer.compact()).flip();
            memento.getLine().setPositionByteBuffer(0);
        }
        int mark = buffer.position();
        ((Buffer)buffer).position(buffer.limit());
        ((Buffer)buffer).limit(Math.min(buffer.position() + recommendedCount, buffer.capacity()));
        return this.read(buffer, mark, recommendedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamReadStatus read(ByteBuffer buffer, int oldPosition, int recommendedCount) throws IOException {
        boolean readComplete;
        StreamReadStatus readStatus = null;
        boolean isEnd = false;
        try {
            while (!isEnd && buffer.position() - oldPosition < recommendedCount && buffer.position() < buffer.limit()) {
                isEnd = this.channel.read(buffer) == -1;
            }
            ((Buffer)buffer).limit(buffer.position());
        }
        catch (Throwable throwable) {
            boolean readComplete2;
            ((Buffer)buffer).limit(buffer.position());
            ((Buffer)buffer).position(oldPosition);
            int readBytes = buffer.remaining();
            boolean bl = readComplete2 = readBytes >= recommendedCount;
            if (!isEnd || readComplete2) {
                this.debugStream(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                readStatus = readComplete2 ? StreamReadStatus.OVERFLOW : StreamReadStatus.UNDERFLOW;
            }
            throw throwable;
        }
        ((Buffer)buffer).position(oldPosition);
        int readBytes = buffer.remaining();
        boolean bl = readComplete = readBytes >= recommendedCount;
        if (!isEnd || readComplete) {
            this.debugStream(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            readStatus = readComplete ? StreamReadStatus.OVERFLOW : StreamReadStatus.UNDERFLOW;
        }
        if (readStatus == null) {
            throw new EOFException();
        }
        return readStatus;
    }

    public final class Memento {
        private CharsetDecoder currentDecoder;
        private final CharsetDecoder defaultDecoder;
        private final BufferedStream line;
        private final List<Object> data;
        private final CharBuffer cb;
        private final ByteBuffer bb;

        public Memento() {
            this.line = new BufferedStream(32);
            this.data = new ArrayList<Object>();
            this.cb = CharBuffer.allocate(1024);
            this.bb = ByteBuffer.allocate(1024);
            this.defaultDecoder = Constants.DEFAULT_STREAM_ENCODING.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            ((Buffer)this.bb).limit(0);
        }

        public void reset() {
            this.currentDecoder = null;
            this.data.clear();
        }

        public CharsetDecoder getDecoder() {
            return this.currentDecoder == null ? this.defaultDecoder : this.currentDecoder;
        }

        public void setCharset(Charset charset) {
            this.currentDecoder = charset.name().equals(this.defaultDecoder.charset().name()) ? this.defaultDecoder : charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        public BufferedStream getLine() {
            return this.line;
        }

        public List<Object> getData() {
            return this.data;
        }

        public <T> T ofDataAt(int indexOfData) {
            return (T)this.data.get(indexOfData);
        }

        public CharBuffer getCharBuffer() {
            return this.cb;
        }

        public ByteBuffer getByteBuffer() {
            return this.bb;
        }
    }

    public static enum StreamReadStatus {
        UNDERFLOW,
        OVERFLOW,
        EOF;

    }

    public static final class Segment {
        private final byte[] array;
        private final int fromIndex;
        private final int length;
        private final int hashCode;

        public Segment(byte[] array, int fromIndex, int length) {
            this.array = array;
            this.fromIndex = fromIndex;
            this.length = length;
            int hashCode = 0;
            int i = fromIndex;
            int loops = length >> 1;
            while (loops-- != 0) {
                hashCode = 31 * hashCode + array[i++];
                hashCode = 31 * hashCode + array[i++];
            }
            this.hashCode = i == fromIndex + length ? hashCode : 31 * hashCode + array[i];
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Segment)) {
                return false;
            }
            Segment that = (Segment)obj;
            if (that.length != this.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (that.array[that.fromIndex + i] == this.array[this.fromIndex + i]) continue;
                return false;
            }
            return true;
        }
    }

    public static final class MalformedFrameException
    extends Exception {
        private final int readFrom;
        private final int readTo;

        public MalformedFrameException(int readFrom, int readTo) {
            this.readFrom = readFrom;
            this.readTo = readTo;
        }

        public int readFrom() {
            return this.readFrom;
        }

        public int readTo() {
            return this.readTo;
        }

        public boolean hasValidPositions() {
            return this.readFrom != -1 && this.readTo != -1 && this.readTo - this.readFrom > 0;
        }
    }

    public final class BufferedStream {
        private byte[] buffer;
        private int count;
        private int positionByteBuffer;
        private boolean isNewLine;

        BufferedStream(int capacity) {
            this.buffer = new byte[capacity];
        }

        public int getPositionByteBuffer() {
            return this.positionByteBuffer;
        }

        public void setPositionByteBuffer(int positionByteBuffer) {
            this.positionByteBuffer = positionByteBuffer;
        }

        public void write(ByteBuffer bb, int position, int length) {
            this.ensureCapacity(length);
            byte[] array = bb.array();
            int pos = bb.arrayOffset() + position;
            while (length-- > 0) {
                byte b;
                ++this.positionByteBuffer;
                if ((b = array[pos++]) == 13 || b == 10) {
                    if (!this.isNewLine) {
                        this.printExistingLine();
                        this.count = 0;
                    }
                    this.isNewLine = true;
                    continue;
                }
                this.buffer[this.count++] = b;
                this.isNewLine = false;
            }
        }

        public void clear() {
            this.count = 0;
        }

        public String toString() {
            return new String(this.buffer, 0, this.count, Constants.DEFAULT_STREAM_ENCODING);
        }

        private boolean isEmpty() {
            return this.count == 0;
        }

        private void ensureCapacity(int addCapacity) {
            int oldCapacity = this.buffer.length;
            int exactCapacity = this.count + addCapacity;
            if (exactCapacity < 0) {
                throw new OutOfMemoryError();
            }
            if (oldCapacity < exactCapacity) {
                int newCapacity = oldCapacity << 1;
                this.buffer = Arrays.copyOf(this.buffer, Math.max(newCapacity, exactCapacity));
            }
        }

        void printExistingLine() {
            if (this.isEmpty()) {
                return;
            }
            String s = this.toString();
            if (StringUtils.isBlank((CharSequence)s)) {
                return;
            }
            if (s.contains(AbstractStreamDecoder.PRINTABLE_JVM_NATIVE_STREAM)) {
                if (AbstractStreamDecoder.this.logger.isDebugEnabled()) {
                    AbstractStreamDecoder.this.logger.debug(s);
                } else if (AbstractStreamDecoder.this.logger.isInfoEnabled()) {
                    AbstractStreamDecoder.this.logger.info(s);
                } else {
                    System.out.println(s);
                }
            } else {
                if (this.isJvmError(s)) {
                    AbstractStreamDecoder.this.logger.error(s);
                } else if (AbstractStreamDecoder.this.logger.isDebugEnabled()) {
                    AbstractStreamDecoder.this.logger.debug(s);
                }
                String msg = "Corrupted channel by directly writing to native stream in forked JVM " + AbstractStreamDecoder.this.arguments.getForkChannelId() + ".";
                File dumpFile = AbstractStreamDecoder.this.arguments.dumpStreamText(msg + " Stream '" + s + "'.");
                String dumpPath = dumpFile.getAbsolutePath();
                AbstractStreamDecoder.this.arguments.logWarningAtEnd(msg + " See FAQ web page and the dump file " + dumpPath);
            }
        }

        private boolean isJvmError(String line) {
            String lineLower = line.toLowerCase();
            for (String errorPattern : JVM_ERROR_PATTERNS) {
                if (!lineLower.contains(errorPattern)) continue;
                return true;
            }
            return false;
        }
    }
}

