/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.net.util.Base64;

public final class RSAUtils$ {
    public static final RSAUtils$ MODULE$;
    private final KeyPair keyPair;

    static {
        new RSAUtils$();
    }

    private KeyPair keyPair() {
        return this.keyPair;
    }

    public KeyPair genKeyPair(int keyLength) {
        KeyPairGenerator keyPair = KeyPairGenerator.getInstance("RSA");
        keyPair.initialize(keyLength);
        return keyPair.generateKeyPair();
    }

    public String getDefaultPublicKey() {
        return new String(Base64.encodeBase64((byte[])this.keyPair().getPublic().getEncoded()), StandardCharsets.UTF_8);
    }

    public String getDefaultPrivateKey() {
        return new String(Base64.encodeBase64((byte[])this.keyPair().getPrivate().getEncoded()), StandardCharsets.UTF_8);
    }

    public byte[] encrypt(byte[] data, PublicKey publicKey) {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public byte[] encrypt(byte[] data) {
        return this.encrypt(data, this.keyPair().getPublic());
    }

    public byte[] decrypt(String data, PrivateKey privateKey) {
        byte[] dataBytes = Hex.decodeHex((char[])data.toCharArray());
        return this.decrypt(dataBytes, privateKey);
    }

    public byte[] decrypt(String data) {
        return this.decrypt(data, this.keyPair().getPrivate());
    }

    public byte[] decrypt(byte[] data, PrivateKey privateKey) {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data) {
        return this.decrypt(data, this.keyPair().getPrivate());
    }

    private RSAUtils$() {
        MODULE$ = this;
        this.keyPair = this.genKeyPair(1024);
    }
}

