/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import java.util.Hashtable;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;

public final class LDAPUtils$
implements Logging {
    public static final LDAPUtils$ MODULE$;
    private final String url;
    private final String baseDN;
    private final String userNameFormat;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LDAPUtils$();
    }

    private Logger logger$lzycompute() {
        LDAPUtils$ lDAPUtils$ = this;
        synchronized (lDAPUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void trace(Function0<String> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging$class.info(this, message, t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging$class.warn(this, message, t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging$class.error(this, message, t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging$class.error(this, message);
    }

    public String url() {
        return this.url;
    }

    public String baseDN() {
        return this.baseDN;
    }

    public String userNameFormat() {
        return this.userNameFormat;
    }

    public void login(String userID, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        String bindDN = StringUtils.isBlank((String)this.userNameFormat()) ? userID : Predef$.MODULE$.refArrayOps((Object[])this.userNameFormat().split("%s", -1)).mkString(userID);
        String bindPassword = password;
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", new StringBuilder().append((Object)this.url()).append((Object)this.baseDN()).toString());
        env.put("java.naming.security.principal", bindDN);
        env.put("java.naming.security.credentials", bindPassword);
        new InitialLdapContext(env, null);
        this.info((Function0<String>)new Serializable(userID){
            public static final long serialVersionUID = 0L;
            private final String userID$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " login success."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userID$1}));
            }
            {
                this.userID$1 = userID$1;
            }
        });
    }

    private LDAPUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.url = CommonVars$.MODULE$.apply("wds.linkis.ldap.proxy.url", "").getValue();
        this.baseDN = CommonVars$.MODULE$.apply("wds.linkis.ldap.proxy.baseDN", "").getValue();
        this.userNameFormat = CommonVars$.MODULE$.apply("wds.linkis.ldap.proxy.userNameFormat", "").getValue();
    }
}

