/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ByteTimeUtils {
    private static final ImmutableMap<String, TimeUnit> timeSuffixes = ImmutableMap.builder().put((Object)"us", (Object)TimeUnit.MICROSECONDS).put((Object)"ms", (Object)TimeUnit.MILLISECONDS).put((Object)"s", (Object)TimeUnit.SECONDS).put((Object)"m", (Object)TimeUnit.MINUTES).put((Object)"min", (Object)TimeUnit.MINUTES).put((Object)"h", (Object)TimeUnit.HOURS).put((Object)"d", (Object)TimeUnit.DAYS).build();
    private static final ImmutableMap<String, ByteUnit> byteSuffixes = ImmutableMap.builder().put((Object)"b", (Object)ByteUnit.BYTE).put((Object)"k", (Object)ByteUnit.KiB).put((Object)"kb", (Object)ByteUnit.KiB).put((Object)"m", (Object)ByteUnit.MiB).put((Object)"mb", (Object)ByteUnit.MiB).put((Object)"g", (Object)ByteUnit.GiB).put((Object)"gb", (Object)ByteUnit.GiB).put((Object)"t", (Object)ByteUnit.TiB).put((Object)"tb", (Object)ByteUnit.TiB).put((Object)"p", (Object)ByteUnit.PiB).put((Object)"pb", (Object)ByteUnit.PiB).build();

    public static int nonNegativeHash(Object obj) {
        if (obj == null) {
            return 0;
        }
        int hash = obj.hashCode();
        return hash != Integer.MIN_VALUE ? Math.abs(hash) : 0;
    }

    public static void deleteRecursively(File file) throws IOException {
        boolean deleted;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && !ByteTimeUtils.isSymlink(file)) {
            IOException savedIOException = null;
            for (File child : ByteTimeUtils.listFilesSafely(file)) {
                try {
                    ByteTimeUtils.deleteRecursively(child);
                }
                catch (IOException e) {
                    savedIOException = e;
                }
            }
            if (savedIOException != null) {
                throw savedIOException;
            }
        }
        if (!(deleted = file.delete()) && file.exists()) {
            throw new IOException("Failed to delete: " + file.getAbsolutePath());
        }
    }

    private static File[] listFilesSafely(File file) throws IOException {
        if (file.exists()) {
            File[] files = file.listFiles();
            if (files == null) {
                throw new IOException("Failed to list files for dir: " + file);
            }
            return files;
        }
        return new File[0];
    }

    private static boolean isSymlink(File file) throws IOException {
        File fileInCanonicalDir = null;
        fileInCanonicalDir = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    private static long parseTimeString(String str, TimeUnit unit) {
        String lower = str.toLowerCase().trim();
        try {
            Matcher m = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(lower);
            if (!m.matches()) {
                throw new NumberFormatException("Failed to parse time string: " + str);
            }
            long val = Long.parseLong(m.group(1));
            String suffix = m.group(2);
            if (suffix != null && !timeSuffixes.containsKey((Object)suffix)) {
                throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
            }
            return unit.convert(val, suffix != null ? (TimeUnit)((Object)timeSuffixes.get((Object)suffix)) : unit);
        }
        catch (NumberFormatException e) {
            String timeError = "Time " + str + " must be specified as seconds (s), milliseconds (ms), microseconds (us), minutes (m or min), hour (h), or day (d). E.g. 50s, 100ms, or 250us.";
            throw new NumberFormatException(timeError + "\n" + e.getMessage());
        }
    }

    public static long timeStringAsMs(String str) {
        return ByteTimeUtils.parseTimeString(str, TimeUnit.MILLISECONDS);
    }

    public static long timeStringAsSec(String str) {
        return ByteTimeUtils.parseTimeString(str, TimeUnit.SECONDS);
    }

    public static String msDurationToString(long ms) {
        int second = 1000;
        int minute = 60 * second;
        int hour = 60 * minute;
        Locale locale = Locale.US;
        if (ms < (long)second) {
            return String.format(locale, "%d ms", ms);
        }
        if (ms < (long)minute) {
            return String.format(locale, "%.1f s", Float.valueOf((float)ms * 1.0f / (float)second));
        }
        if (ms < (long)hour) {
            return String.format(locale, "%.1f m", Float.valueOf((float)ms * 1.0f / (float)minute));
        }
        return String.format(locale, "%.2f h", Float.valueOf((float)ms * 1.0f / (float)hour));
    }

    private static long parseByteString(String str, ByteUnit unit) {
        String lower = str.toLowerCase().trim();
        try {
            String suffix;
            Matcher m = Pattern.compile("([0-9]+)\\s?([a-zA-Z]+)?").matcher(lower);
            Matcher fractionMatcher = Pattern.compile("([0-9]+\\.[0-9]+)\\s?([a-zA-Z]{1,2})?").matcher(lower);
            long size = 0L;
            int sub = 1;
            if (fractionMatcher.matches()) {
                double val = Double.parseDouble(fractionMatcher.group(1));
                size = (long)(val * 100.0);
                suffix = fractionMatcher.group(2);
                sub = 100;
            } else if (m.matches()) {
                size = Long.parseLong(m.group(1));
                suffix = m.group(2);
            } else {
                throw new NumberFormatException("Failed to parse byte string: " + str);
            }
            suffix = suffix.toLowerCase();
            if (suffix != null && !byteSuffixes.containsKey((Object)suffix)) {
                throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
            }
            return unit.convertFrom(size, suffix != null ? (ByteUnit)((Object)byteSuffixes.get((Object)suffix)) : unit) / (long)sub;
        }
        catch (NumberFormatException e) {
            String timeError = "Error size string " + str + ". Size must be specified as bytes (b), kibibytes (k), mebibytes (m), gibibytes (g), tebibytes (t), or pebibytes(p). E.g. 50b, 100k, or 250m.";
            throw new IllegalArgumentException(timeError, e);
        }
    }

    public static String bytesToString(long size) {
        String unit;
        double value;
        long TB = 0x10000000000L;
        long GB = 0x40000000L;
        long MB = 0x100000L;
        long KB = 1024L;
        if (size >= 2L * TB || -2L * TB >= size) {
            value = (float)size * 1.0f / (float)TB;
            unit = "TB";
        } else if (size >= 2L * GB || -2L * GB >= size) {
            value = (float)size * 1.0f / (float)GB;
            unit = "GB";
        } else if (size >= 2L * MB || -2L * MB >= size) {
            value = (float)size * 1.0f / (float)MB;
            unit = "MB";
        } else if (size >= 2L * KB || -2L * KB >= size) {
            value = (float)size * 1.0f / (float)KB;
            unit = "KB";
        } else {
            value = (float)size * 1.0f;
            unit = "B";
        }
        return String.format(Locale.US, "%.1f %s", value, unit);
    }

    public static long byteStringAsBytes(String str) {
        return ByteTimeUtils.parseByteString(str, ByteUnit.BYTE);
    }

    public static long byteStringAsKb(String str) {
        return ByteTimeUtils.parseByteString(str, ByteUnit.KiB);
    }

    public static long byteStringAsMb(String str) {
        return ByteTimeUtils.parseByteString(str, ByteUnit.MiB);
    }

    public static long byteStringAsGb(String str) {
        return ByteTimeUtils.parseByteString(str, ByteUnit.GiB);
    }

    public static byte[] bufferToArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.array().length == buffer.remaining()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    static enum ByteUnit {
        BYTE(1L),
        KiB(1024L),
        MiB((long)Math.pow(1024.0, 2.0)),
        GiB((long)Math.pow(1024.0, 3.0)),
        TiB((long)Math.pow(1024.0, 4.0)),
        PiB((long)Math.pow(1024.0, 5.0));

        private final long multiplier;

        private ByteUnit(long multiplier) {
            this.multiplier = multiplier;
        }

        public long convertFrom(long d, ByteUnit u) {
            return u.convertTo(d, this);
        }

        public long convertTo(long d, ByteUnit u) {
            if (this.multiplier > u.multiplier) {
                long ratio = this.multiplier / u.multiplier;
                if (Long.MAX_VALUE / ratio < d) {
                    throw new IllegalArgumentException("Conversion of " + d + " exceeds Long.MAX_VALUE in " + this.name() + ". Try a larger unit (e.g. MiB instead of KiB)");
                }
                return d * ratio;
            }
            return d / (u.multiplier / this.multiplier);
        }

        public double toBytes(long d) {
            if (d < 0L) {
                throw new IllegalArgumentException("Negative size value. Size must be positive: " + d);
            }
            return d * this.multiplier;
        }

        public long toKiB(long d) {
            return this.convertTo(d, KiB);
        }

        public long toMiB(long d) {
            return this.convertTo(d, MiB);
        }

        public long toGiB(long d) {
            return this.convertTo(d, GiB);
        }

        public long toTiB(long d) {
            return this.convertTo(d, TiB);
        }

        public long toPiB(long d) {
            return this.convertTo(d, PiB);
        }
    }
}

