/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client.shaded.com.sangupta.murmur;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.kudu.client.shaded.com.sangupta.murmur.MurmurConstants;

public class Murmur3
implements MurmurConstants {
    private static final int X86_32_C1 = -862048943;
    private static final int X86_32_C2 = 461845907;
    private static long X64_128_C1 = -8663945395140668459L;
    private static long X64_128_C2 = 5545529020109919103L;

    public static long hash_x86_32(byte[] data, int length, long seed) {
        int nblocks = length >> 2;
        long hash = seed;
        for (int i = 0; i < nblocks; ++i) {
            int i4 = i << 2;
            long k1 = data[i4] & 0xFF;
            k1 |= (long)((data[i4 + 1] & 0xFF) << 8);
            k1 |= (long)((data[i4 + 2] & 0xFF) << 16);
            k1 |= (long)((data[i4 + 3] & 0xFF) << 24);
            k1 = k1 * -862048943L & 0xFFFFFFFFL;
            k1 = Murmur3.rotl32(k1, 15);
            k1 = k1 * 461845907L & 0xFFFFFFFFL;
            hash ^= k1;
            hash = Murmur3.rotl32(hash, 13);
            hash = (hash * 5L & 0xFFFFFFFFL) + 3864292196L & 0xFFFFFFFFL;
        }
        int offset = nblocks << 2;
        long k1 = 0L;
        switch (length & 3) {
            case 3: {
                k1 ^= (long)(data[offset + 2] << 16) & 0xFFFFFFFFL;
            }
            case 2: {
                k1 ^= (long)(data[offset + 1] << 8) & 0xFFFFFFFFL;
            }
            case 1: {
                k1 ^= (long)data[offset];
                k1 = k1 * -862048943L & 0xFFFFFFFFL;
                k1 = Murmur3.rotl32(k1, 15);
                k1 = k1 * 461845907L & 0xFFFFFFFFL;
                hash ^= k1;
            }
        }
        hash ^= (long)length;
        hash = Murmur3.fmix32(hash);
        return hash;
    }

    public static long[] hash_x64_128(byte[] data, int length, long seed) {
        long h1 = seed;
        long h2 = seed;
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        while (buffer.remaining() >= 16) {
            long k1 = buffer.getLong();
            long k2 = buffer.getLong();
            h1 ^= Murmur3.mixK1(k1);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            h2 ^= Murmur3.mixK2(k2);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        buffer.compact();
        buffer.flip();
        int remaining = buffer.remaining();
        if (remaining > 0) {
            long k1 = 0L;
            long k2 = 0L;
            switch (buffer.remaining()) {
                case 15: {
                    k2 ^= (long)(buffer.get(14) & 0xFF) << 48;
                }
                case 14: {
                    k2 ^= (long)(buffer.get(13) & 0xFF) << 40;
                }
                case 13: {
                    k2 ^= (long)(buffer.get(12) & 0xFF) << 32;
                }
                case 12: {
                    k2 ^= (long)(buffer.get(11) & 0xFF) << 24;
                }
                case 11: {
                    k2 ^= (long)(buffer.get(10) & 0xFF) << 16;
                }
                case 10: {
                    k2 ^= (long)(buffer.get(9) & 0xFF) << 8;
                }
                case 9: {
                    k2 ^= (long)(buffer.get(8) & 0xFF);
                }
                case 8: {
                    k1 ^= buffer.getLong();
                    break;
                }
                case 7: {
                    k1 ^= (long)(buffer.get(6) & 0xFF) << 48;
                }
                case 6: {
                    k1 ^= (long)(buffer.get(5) & 0xFF) << 40;
                }
                case 5: {
                    k1 ^= (long)(buffer.get(4) & 0xFF) << 32;
                }
                case 4: {
                    k1 ^= (long)(buffer.get(3) & 0xFF) << 24;
                }
                case 3: {
                    k1 ^= (long)(buffer.get(2) & 0xFF) << 16;
                }
                case 2: {
                    k1 ^= (long)(buffer.get(1) & 0xFF) << 8;
                }
                case 1: {
                    k1 ^= (long)(buffer.get(0) & 0xFF);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Code should not reach here!");
                }
            }
            h1 ^= Murmur3.mixK1(k1);
            h2 ^= Murmur3.mixK2(k2);
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = Murmur3.fmix64(h1);
        h2 = Murmur3.fmix64(h2);
        h1 += h2;
        return new long[]{h1, h2 += h1};
    }

    private static long mixK1(long k1) {
        k1 *= X64_128_C1;
        k1 = Long.rotateLeft(k1, 31);
        return k1 *= X64_128_C2;
    }

    private static long mixK2(long k2) {
        k2 *= X64_128_C2;
        k2 = Long.rotateLeft(k2, 33);
        return k2 *= X64_128_C1;
    }

    private static long rotl32(long original, int shift) {
        return original << shift & 0xFFFFFFFFL | original >>> 32 - shift & 0xFFFFFFFFL;
    }

    private static long fmix32(long h) {
        h ^= h >> 16 & 0xFFFFFFFFL;
        h = h * 2246822507L & 0xFFFFFFFFL;
        h ^= h >> 13 & 0xFFFFFFFFL;
        h = h * -1028477387L & 0xFFFFFFFFL;
        h ^= h >> 16 & 0xFFFFFFFFL;
        return h;
    }

    private static long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }
}

