/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.shaded.com.google.common.net.HostAndPort;
import org.apache.kudu.util.NetUtil;

@InterfaceAudience.Private
public class ServerInfo {
    private final String uuid;
    private final HostAndPort hostPort;
    private final InetAddress resolvedAddr;
    private final boolean local;
    private static final ConcurrentHashMap<InetAddress, Boolean> isLocalAddressCache = new ConcurrentHashMap();

    public ServerInfo(String uuid, HostAndPort hostPort, InetAddress resolvedAddr) {
        this.uuid = uuid;
        this.hostPort = hostPort;
        this.resolvedAddr = resolvedAddr;
        Boolean isLocal = isLocalAddressCache.get(resolvedAddr);
        if (isLocal == null) {
            isLocal = NetUtil.isLocalAddress(resolvedAddr);
            isLocalAddressCache.put(resolvedAddr, isLocal);
        }
        this.local = isLocal;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getHostname() {
        return this.hostPort.getHostText();
    }

    public int getPort() {
        return this.hostPort.getPort();
    }

    public boolean isLocal() {
        return this.local;
    }

    public InetAddress getResolvedAddress() {
        return this.resolvedAddr;
    }
}

