/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.Schema;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.AbstractKuduScannerBuilder;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartitionPruner;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.client.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduScanner {
    private final AsyncKuduScanner asyncScanner;

    KuduScanner(AsyncKuduScanner asyncScanner) {
        this.asyncScanner = asyncScanner;
    }

    public boolean hasMoreRows() {
        return this.asyncScanner.hasMoreRows();
    }

    public RowResultIterator nextRows() throws KuduException {
        return KuduClient.joinAndHandleException(this.asyncScanner.nextRows());
    }

    public RowResultIterator close() throws KuduException {
        return KuduClient.joinAndHandleException(this.asyncScanner.close());
    }

    public long getLimit() {
        return this.asyncScanner.getLimit();
    }

    public boolean getCacheBlocks() {
        return this.asyncScanner.getCacheBlocks();
    }

    public long getBatchSizeBytes() {
        return this.asyncScanner.getBatchSizeBytes();
    }

    public AsyncKuduScanner.ReadMode getReadMode() {
        return this.asyncScanner.getReadMode();
    }

    public Schema getProjectionSchema() {
        return this.asyncScanner.getProjectionSchema();
    }

    @VisibleForTesting
    RemoteTablet currentTablet() {
        return this.asyncScanner.currentTablet();
    }

    @VisibleForTesting
    ReplicaSelection getReplicaSelection() {
        return this.asyncScanner.getReplicaSelection();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class KuduScannerBuilder
    extends AbstractKuduScannerBuilder<KuduScannerBuilder, KuduScanner> {
        KuduScannerBuilder(AsyncKuduClient client, KuduTable table) {
            super(client, table);
        }

        @Override
        public KuduScanner build() {
            return new KuduScanner(new AsyncKuduScanner(this.client, this.table, this.projectedColumnNames, this.projectedColumnIndexes, this.readMode, this.isFaultTolerant, this.scanRequestTimeout, this.predicates, this.limit, this.cacheBlocks, this.prefetching, this.lowerBoundPrimaryKey, this.upperBoundPrimaryKey, this.htTimestamp, this.batchSizeBytes, PartitionPruner.create(this), this.replicaSelection));
        }
    }
}

