/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.Schema;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.GetTableSchemaResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
public class GetTableSchemaRequest
extends KuduRpc<GetTableSchemaResponse> {
    static final String GET_TABLE_SCHEMA = "GetTableSchema";
    private final String name;

    GetTableSchemaRequest(KuduTable masterTable, String name) {
        super(masterTable);
        this.name = name;
    }

    @Override
    Message createRequestPB() {
        Master.GetTableSchemaRequestPB.Builder builder = Master.GetTableSchemaRequestPB.newBuilder();
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        builder.setTable(tableID);
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return GET_TABLE_SCHEMA;
    }

    @Override
    Pair<GetTableSchemaResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.GetTableSchemaResponsePB.Builder respBuilder = Master.GetTableSchemaResponsePB.newBuilder();
        GetTableSchemaRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        Schema schema = ProtobufHelper.pbToSchema(respBuilder.getSchema());
        GetTableSchemaResponse response = new GetTableSchemaResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, schema, respBuilder.getTableId().toStringUtf8(), ProtobufHelper.pbToPartitionSchema(respBuilder.getPartitionSchema(), schema), respBuilder.getCreateTableDone());
        return new Pair<GetTableSchemaResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

