/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.CacheFlushListener;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.FilteredCacheIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheSessionStoreIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class CachingSessionStore<K, AGG>
extends WrappedStateStore.AbstractStateStore
implements SessionStore<K, AGG>,
CachedStateStore<Windowed<K>, AGG> {
    private final SessionStore<Bytes, byte[]> bytesStore;
    private final SessionKeySchema keySchema;
    private final Serde<K> keySerde;
    private final Serde<AGG> aggSerde;
    private final SegmentedCacheFunction cacheFunction;
    private String cacheName;
    private ThreadCache cache;
    private StateSerdes<K, AGG> serdes;
    private InternalProcessorContext context;
    private CacheFlushListener<Windowed<K>, AGG> flushListener;
    private String topic;

    CachingSessionStore(SessionStore<Bytes, byte[]> bytesStore, Serde<K> keySerde, Serde<AGG> aggSerde, long segmentInterval) {
        super(bytesStore);
        this.bytesStore = bytesStore;
        this.keySerde = keySerde;
        this.aggSerde = aggSerde;
        this.keySchema = new SessionKeySchema();
        this.cacheFunction = new SegmentedCacheFunction(this.keySchema, segmentInterval);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), root.name());
        this.bytesStore.init(context, root);
        this.initInternal((InternalProcessorContext)context);
    }

    private void initInternal(final InternalProcessorContext context) {
        this.context = context;
        this.keySchema.init(this.topic);
        this.serdes = new StateSerdes(this.topic, (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.aggSerde == null ? context.valueSerde() : this.aggSerde));
        this.cacheName = context.taskId() + "-" + this.bytesStore.name();
        this.cache = context.getCache();
        this.cache.addDirtyEntryFlushListener(this.cacheName, new ThreadCache.DirtyEntryFlushListener(){

            @Override
            public void apply(List<ThreadCache.DirtyEntry> entries) {
                for (ThreadCache.DirtyEntry entry : entries) {
                    CachingSessionStore.this.putAndMaybeForward(entry, context);
                }
            }
        });
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        this.validateStoreOpen();
        Bytes binarySessionId = Bytes.wrap((byte[])this.serdes.rawKey(key));
        Bytes cacheKeyFrom = this.cacheFunction.cacheKey(this.keySchema.lowerRangeFixedSize(binarySessionId, earliestSessionEndTime));
        Bytes cacheKeyTo = this.cacheFunction.cacheKey(this.keySchema.upperRangeFixedSize(binarySessionId, latestSessionStartTime));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range(this.cacheName, cacheKeyFrom, cacheKeyTo);
        KeyValueIterator<Windowed<Bytes>, byte[]> storeIterator = this.bytesStore.findSessions(binarySessionId, earliestSessionEndTime, latestSessionStartTime);
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(binarySessionId, binarySessionId, earliestSessionEndTime, latestSessionStartTime);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, this.cacheFunction);
        return new MergedSortedCacheSessionStoreIterator<K, AGG>(filteredCacheIterator, storeIterator, this.serdes, this.cacheFunction);
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> findSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        this.validateStoreOpen();
        Bytes binarySessionIdFrom = Bytes.wrap((byte[])this.serdes.rawKey(keyFrom));
        Bytes binarySessionIdTo = Bytes.wrap((byte[])this.serdes.rawKey(keyTo));
        Bytes cacheKeyFrom = this.cacheFunction.cacheKey(this.keySchema.lowerRange(binarySessionIdFrom, earliestSessionEndTime));
        Bytes cacheKeyTo = this.cacheFunction.cacheKey(this.keySchema.upperRange(binarySessionIdTo, latestSessionStartTime));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range(this.cacheName, cacheKeyFrom, cacheKeyTo);
        KeyValueIterator<Windowed<Bytes>, byte[]> storeIterator = this.bytesStore.findSessions(binarySessionIdFrom, binarySessionIdTo, earliestSessionEndTime, latestSessionStartTime);
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(binarySessionIdFrom, binarySessionIdTo, earliestSessionEndTime, latestSessionStartTime);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, this.cacheFunction);
        return new MergedSortedCacheSessionStoreIterator<K, AGG>(filteredCacheIterator, storeIterator, this.serdes, this.cacheFunction);
    }

    @Override
    public void remove(Windowed<K> sessionKey) {
        this.validateStoreOpen();
        this.put(sessionKey, null);
    }

    @Override
    public void put(Windowed<K> key, AGG value) {
        this.validateStoreOpen();
        Bytes binaryKey = SessionKeySerde.toBinary(key, this.serdes.keySerializer(), this.topic);
        LRUCacheEntry entry = new LRUCacheEntry(this.serdes.rawValue(value), true, this.context.offset(), key.window().end(), this.context.partition(), this.context.topic());
        this.cache.put(this.cacheName, this.cacheFunction.cacheKey(binaryKey), entry);
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> fetch(K key) {
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> fetch(K from, K to) {
        return this.findSessions(from, to, 0L, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndMaybeForward(ThreadCache.DirtyEntry entry, InternalProcessorContext context) {
        Bytes binaryKey = this.cacheFunction.key(entry.key());
        RecordContext current = context.recordContext();
        context.setRecordContext(entry.recordContext());
        try {
            Windowed<K> key = SessionKeySerde.from(binaryKey.get(), this.serdes.keyDeserializer(), this.topic);
            Bytes rawKey = Bytes.wrap((byte[])this.serdes.rawKey(key.key()));
            if (this.flushListener != null) {
                AGG newValue = this.serdes.valueFrom(entry.newValue());
                AGG oldValue = this.fetchPrevious(rawKey, key.window());
                if (newValue != null || oldValue != null) {
                    this.flushListener.apply(key, newValue, oldValue);
                }
            }
            this.bytesStore.put(new Windowed<Bytes>(rawKey, key.window()), entry.newValue());
        }
        finally {
            context.setRecordContext(current);
        }
    }

    private AGG fetchPrevious(Bytes rawKey, Window window) {
        try (KeyValueIterator<Windowed<Bytes>, byte[]> iterator = this.bytesStore.findSessions(rawKey, window.start(), window.end());){
            if (!iterator.hasNext()) {
                AGG AGG = null;
                return AGG;
            }
            AGG AGG = this.serdes.valueFrom((byte[])((KeyValue)iterator.next()).value);
            return AGG;
        }
    }

    @Override
    public void flush() {
        this.cache.flush(this.cacheName);
        this.bytesStore.flush();
    }

    @Override
    public void close() {
        this.flush();
        this.cache.close(this.cacheName);
        this.bytesStore.close();
    }

    @Override
    public void setFlushListener(CacheFlushListener<Windowed<K>, AGG> flushListener) {
        this.flushListener = flushListener;
    }
}

