/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class QuotaRecord
implements ApiMessage {
    List<EntityData> entity;
    String key;
    double value;
    boolean remove;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("entity", (Type)new ArrayOf((Type)EntityData.SCHEMA_0), "The quota entity to alter."), new Field("key", (Type)Type.STRING, "The quota configuration key."), new Field("value", (Type)Type.FLOAT64, "The value to set, otherwise ignored if the value is to be removed."), new Field("remove", (Type)Type.BOOLEAN, "Whether the quota configuration value should be removed, otherwise set.")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public QuotaRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public QuotaRecord() {
        this.entity = new ArrayList<EntityData>(0);
        this.key = "";
        this.value = 0.0;
        this.remove = false;
    }

    public short apiKey() {
        return 14;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field entity was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<EntityData> newCollection = new ArrayList<EntityData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new EntityData(_readable, _version));
        }
        this.entity = newCollection;
        short length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field key was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field key had invalid length " + length);
        }
        this.key = _readable.readString((int)length);
        this.value = _readable.readDouble();
        this.remove = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.entity.size());
        for (EntityData entityElement : this.entity) {
            entityElement.write(_writable, _cache, _version);
        }
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.key);
        _writable.writeShort((short)_stringBytes.length);
        _writable.writeByteArray(_stringBytes);
        _writable.writeDouble(this.value);
        _writable.writeByte(this.remove ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        for (EntityData entityElement : this.entity) {
            entityElement.addSize(_size, _cache, _version);
        }
        byte[] _stringBytes = this.key.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'key' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.key, _stringBytes);
        _size.addBytes(_stringBytes.length + 2);
        _size.addBytes(8);
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QuotaRecord)) {
            return false;
        }
        QuotaRecord other = (QuotaRecord)obj;
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.value != other.value) {
            return false;
        }
        if (this.remove != other.remove) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.entity == null ? 0 : this.entity.hashCode());
        hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
        hashCode = 31 * hashCode + Double.hashCode(this.value);
        hashCode = 31 * hashCode + (this.remove ? 1231 : 1237);
        return hashCode;
    }

    public QuotaRecord duplicate() {
        QuotaRecord _duplicate = new QuotaRecord();
        ArrayList<EntityData> newEntity = new ArrayList<EntityData>(this.entity.size());
        for (EntityData _element : this.entity) {
            newEntity.add(_element.duplicate());
        }
        _duplicate.entity = newEntity;
        _duplicate.key = this.key;
        _duplicate.value = this.value;
        _duplicate.remove = this.remove;
        return _duplicate;
    }

    public String toString() {
        return "QuotaRecord(entity=" + MessageUtil.deepToString(this.entity.iterator()) + ", key=" + (this.key == null ? "null" : "'" + this.key.toString() + "'") + ", value=" + this.value + ", remove=" + (this.remove ? "true" : "false") + ")";
    }

    public List<EntityData> entity() {
        return this.entity;
    }

    public String key() {
        return this.key;
    }

    public double value() {
        return this.value;
    }

    public boolean remove() {
        return this.remove;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public QuotaRecord setEntity(List<EntityData> v) {
        this.entity = v;
        return this;
    }

    public QuotaRecord setKey(String v) {
        this.key = v;
        return this;
    }

    public QuotaRecord setValue(double v) {
        this.value = v;
        return this;
    }

    public QuotaRecord setRemove(boolean v) {
        this.remove = v;
        return this;
    }

    public static class EntityData
    implements Message {
        String entityType;
        String entityName;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("entity_type", (Type)Type.STRING, "The entity type."), new Field("entity_name", (Type)Type.NULLABLE_STRING, "The name of the entity, or null if the default.")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public EntityData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public EntityData() {
            this.entityType = "";
            this.entityName = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntityData");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field entityType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field entityType had invalid length " + length);
            }
            this.entityType = _readable.readString((int)length);
            length = _readable.readShort();
            if (length < 0) {
                this.entityName = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field entityName had invalid length " + length);
                }
                this.entityName = _readable.readString((int)length);
            }
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.entityType);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            if (this.entityName == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.entityName);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntityData");
            }
            byte[] _stringBytes = this.entityType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'entityType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.entityType, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            if (this.entityName == null) {
                _size.addBytes(2);
            } else {
                _stringBytes = this.entityName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'entityName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.entityName, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntityData)) {
                return false;
            }
            EntityData other = (EntityData)obj;
            if (this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType)) {
                return false;
            }
            if (this.entityName == null ? other.entityName != null : !this.entityName.equals(other.entityName)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.entityType == null ? 0 : this.entityType.hashCode());
            hashCode = 31 * hashCode + (this.entityName == null ? 0 : this.entityName.hashCode());
            return hashCode;
        }

        public EntityData duplicate() {
            EntityData _duplicate = new EntityData();
            _duplicate.entityType = this.entityType;
            _duplicate.entityName = this.entityName == null ? null : this.entityName;
            return _duplicate;
        }

        public String toString() {
            return "EntityData(entityType=" + (this.entityType == null ? "null" : "'" + this.entityType.toString() + "'") + ", entityName=" + (this.entityName == null ? "null" : "'" + this.entityName.toString() + "'") + ")";
        }

        public String entityType() {
            return this.entityType;
        }

        public String entityName() {
            return this.entityName;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntityData setEntityType(String v) {
            this.entityType = v;
            return this;
        }

        public EntityData setEntityName(String v) {
            this.entityName = v;
            return this;
        }
    }
}

