/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class ThreadDumper {
    private ThreadDumper() {
    }

    public static String threadDump() throws Exception {
        return ThreadDumper.threadDump(new File("."));
    }

    public static String threadDump(File basedir) throws Exception {
        DateTimeFormatter timestampFormat = DateTimeFormatter.ofPattern("yyyyMMdd_hhmmss_SSS").withZone(ZoneId.systemDefault());
        String stamp = timestampFormat.format(Instant.now());
        File temp = new File(basedir, "thread_dump_" + stamp + ".log");
        String path = temp.getPath();
        try (FileOutputStream fos = new FileOutputStream(temp);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);){
            ThreadDumper.writeThreadDump(bufferedWriter);
        }
        return path;
    }

    public static void writeThreadDump(Writer writer) throws IOException {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo ti : threadMxBean.dumpAllThreads(true, true)) {
            writer.write(ti.toString());
        }
    }
}

